/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.platform.server.wls;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.persistence.platform.server.wls.WebLogic_12_Platform;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class WebLogic_12_PlatformTest {
    @After
    public void tearDown() {
        this.resetContextHelper();
    }

    @Test
    public void testUsesPartitions() {
        WebLogic_12_Platform platform = new WebLogic_12_Platform(null);
        Assert.assertFalse((boolean)platform.usesPartitions());
        this.setContextHelper();
        Assert.assertTrue((boolean)platform.usesPartitions());
    }

    @Test
    public void testGetPartitionId() {
        this.setContextHelper();
        WebLogic_12_Platform platform = new WebLogic_12_Platform(null);
        ICtx.ctx = "test3";
        Assert.assertEquals((Object)"test3", (Object)platform.getPartitionID());
        ICtx.ctx = "test1";
        Assert.assertEquals((Object)"test1", (Object)platform.getPartitionID());
    }

    @Test
    public void testGetPartitionName() {
        this.setContextHelper();
        WebLogic_12_Platform platform = new WebLogic_12_Platform(null);
        ICtx.nameCtx = "test3";
        Assert.assertEquals((Object)"test3", (Object)platform.getPartitionName());
        ICtx.nameCtx = "test1";
        Assert.assertEquals((Object)"test1", (Object)platform.getPartitionName());
    }

    @Test
    public void testIsGlobalRuntime() {
        this.setContextHelper();
        WebLogic_12_Platform platform = new WebLogic_12_Platform(null);
        ICtx.isGlobal = true;
        Assert.assertTrue((boolean)platform.isGlobalRuntime());
        ICtx.isGlobal = false;
        Assert.assertFalse((boolean)platform.isGlobalRuntime());
    }

    @Test
    public void testContextHelper() {
        Class<?> contextHelperClass = null;
        for (Class<?> declaredClass : WebLogic_12_Platform.class.getDeclaredClasses()) {
            if (!"org.eclipse.persistence.platform.server.wls.WebLogic_12_Platform$ContextHelper".equals(declaredClass.getName())) continue;
            contextHelperClass = declaredClass;
            break;
        }
        Assert.assertNotNull((String)"ContextHelper class not found", contextHelperClass);
        Method getCicManagerClassMethod = null;
        try {
            getCicManagerClassMethod = contextHelperClass.getDeclaredMethod("getCicManagerClass", String.class, String.class);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)("getCicManagerClass method not found: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"getCicManagerClass method not found", (Object)getCicManagerClassMethod);
        getCicManagerClassMethod.setAccessible(true);
        Object result = null;
        try {
            result = getCicManagerClassMethod.invoke(contextHelperClass, "org/eclipse/persistence/testing/tests/junit/platform/server/wls/WebLogic_12_PlatformTest.class", "org.eclipse.persistence.testing.tests.junit.platform.server.wls.WebLogic_12_PlatformTest");
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to invoke getCicManagerClass method: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"Failed to retrieve test class", (Object)result);
        try {
            result = getCicManagerClassMethod.invoke(contextHelperClass, "this/should/not/resolve", "org.eclipse.persistence.testing.tests.junit.platform.server.wls.WebLogic_12_PlatformTest");
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to invoke getCicManagerClass method: " + e.getMessage()));
        }
        Assert.assertNull((String)"Should have failed to retrieve test class", (Object)result);
        getCicManagerClassMethod.setAccessible(false);
    }

    private void resetContextHelper() {
        try {
            this.setPrivateStaticFinalField(WebLogic_12_Platform.class.getDeclaredField("ctxHelper"), null);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setContextHelper() {
        try {
            this.setPrivateStaticFinalField(WebLogic_12_Platform.class.getDeclaredField("ctxHelper"), this.setUpCtxHelper());
        }
        catch (NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Object setUpCtxHelper() {
        IMgr imgr = new IMgr();
        Constructor<?> c = null;
        Field instanceField = null;
        Object ctxHelperInstance = null;
        try {
            Class<?> ctxHelperClass = Class.forName("org.eclipse.persistence.platform.server.wls.WebLogic_12_Platform$ContextHelper");
            c = ctxHelperClass.getDeclaredConstructors()[0];
            c.setAccessible(true);
            ctxHelperInstance = c.newInstance(imgr.getClass(), ICtx.class.getName());
            this.setPrivateStaticFinalField(ctxHelperClass.getDeclaredField("cicManagerClass"), IMgr.class);
            instanceField = ctxHelperClass.getDeclaredField("instance");
            instanceField.setAccessible(true);
            instanceField.set(null, ctxHelperInstance);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (c != null) {
                c.setAccessible(false);
            }
            if (instanceField != null) {
                instanceField.setAccessible(false);
            }
        }
        return ctxHelperInstance;
    }

    private void setPrivateStaticFinalField(Field f, Object value) {
        Field modifiersField = null;
        int orig = 0;
        try {
            f.setAccessible(true);
            modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            orig = f.getModifiers();
            modifiersField.setInt(f, orig & 0xFFFFFFEF);
            f.set(null, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (modifiersField != null) {
                if (f != null) {
                    try {
                        modifiersField.setInt(f, orig);
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                modifiersField.setAccessible(false);
            }
            if (f != null) {
                f.setAccessible(false);
            }
        }
    }

    private static final class ICtx {
        static volatile String ctx;
        static volatile String nameCtx;
        static volatile boolean isGlobal;

        public String getPartitionId() {
            return ctx;
        }

        public String getPartitionName() {
            return nameCtx;
        }

        public boolean isGlobalRuntime() {
            return isGlobal;
        }
    }

    private static final class IMgr {
        private IMgr() {
        }

        public static IMgr getInstance() {
            return new IMgr();
        }

        public ICtx getCurrentComponentInvocationContext() {
            return new ICtx();
        }
    }
}

