/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class ConformResultsInUnitOfWorkTest
extends JPQLTestCase {
    @Override
    public void test() throws Exception {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setReferenceClass(Employee.class);
        readObjectQuery.setEJBQLString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.id = ?1");
        readObjectQuery.conformResultsInUnitOfWork();
        readObjectQuery.addArgument("1", BigDecimal.class);
        UnitOfWork unitOfWork = this.getSession().acquireUnitOfWork();
        Employee newEmployee = new Employee();
        newEmployee.setId(new BigDecimal(9000));
        unitOfWork.registerObject((Object)newEmployee);
        Vector<BigDecimal> testV = new Vector<BigDecimal>();
        testV.addElement(new BigDecimal(9000));
        Employee result = (Employee)unitOfWork.executeQuery((DatabaseQuery)readObjectQuery, testV);
        if (result == null) {
            throw new TestErrorException("DatabaseSession test: employee with id 9000 expected--returned null");
        }
        Server serverSession = this.getSession().getProject().createServerSession();
        serverSession.setSessionLog(this.getSession().getSessionLog());
        serverSession.login();
        unitOfWork = serverSession.acquireClientSession().acquireUnitOfWork();
        newEmployee = new Employee();
        newEmployee.setId(new BigDecimal(9000));
        unitOfWork.registerObject((Object)newEmployee);
        testV = new Vector();
        testV.addElement(new BigDecimal(9000));
        result = (Employee)unitOfWork.executeQuery((DatabaseQuery)readObjectQuery, testV);
        serverSession.logout();
        if (result == null) {
            throw new TestErrorException("ClientSession test: employee with id 9000 expected--returned null");
        }
    }
}

