/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.interfaces.Employee;

public class QueryAcrossV11Test
extends TestCase {
    public Exception storedException;
    public int expectedExceptionCode;

    public QueryAcrossV11Test() {
        this.setDescription("Test that the correct exception is thrown when a query across a one to one mapping is performed");
        this.storedException = null;
        this.expectedExceptionCode = 6072;
    }

    public void test() {
        try {
            this.getSession().readObject(Employee.class, new ExpressionBuilder().get("contact").get("id").equal(12));
        }
        catch (Exception e) {
            this.storedException = e;
        }
    }

    public void verify() {
        if (this.storedException == null) {
            throw new TestErrorException("NO EXCEPTION THROWN!!!  EXPECTING QueryException");
        }
        if (EclipseLinkException.class.isInstance(this.storedException) && ((EclipseLinkException)((Object)this.storedException)).getErrorCode() == this.expectedExceptionCode) {
            return;
        }
        throw new TestErrorException("WRONG EXCEPTION THROWN!!!  EXPECTING QueryException");
    }
}

