/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.history;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeTableCreator;
import org.eclipse.persistence.tools.history.HistoryFacade;
import org.eclipse.persistence.tools.schemaframework.TableCreator;

public class HistoricalQualifiedTableEmployeeSystem
extends EmployeeSystem {
    public HistoricalQualifiedTableEmployeeSystem(String user) {
        this.project = this.getInitialProject(user);
    }

    public Project getInitialProject(String user) {
        EmployeeProject initialProject = new EmployeeProject();
        HistoryFacade.generateHistoryPolicies(initialProject);
        ClassDescriptor empDescriptor = initialProject.getDescriptor(Employee.class);
        ManyToManyMapping mapping = (ManyToManyMapping)empDescriptor.getMappingForAttributeName("projects");
        String oldRelationTableName = mapping.getRelationTableName();
        List oldHistoricalTableNames = mapping.getHistoryPolicy().getHistoryTableNames();
        mapping.getHistoryPolicy().setHistoricalTables(new Vector(1));
        for (int i = 0; i < oldHistoricalTableNames.size(); ++i) {
            mapping.getHistoryPolicy().addHistoryTableName(user + "." + oldHistoricalTableNames.get(i));
        }
        mapping.setRelationTableName(user + "." + oldRelationTableName);
        Vector targetRelationKeyFields = mapping.getTargetKeyFields();
        for (int i = 0; i < targetRelationKeyFields.size(); ++i) {
            String oldName = ((DatabaseField)targetRelationKeyFields.get(i)).getTable().getName();
            ((DatabaseField)targetRelationKeyFields.get(i)).setTableName(user + "." + oldName);
        }
        Vector sourceRelationKeyFields = mapping.getSourceRelationKeyFields();
        for (int i = 0; i < sourceRelationKeyFields.size(); ++i) {
            String oldName = ((DatabaseField)sourceRelationKeyFields.get(i)).getTable().getName();
            ((DatabaseField)sourceRelationKeyFields.get(i)).setTableName(user + "." + oldName);
        }
        DirectCollectionMapping dcmapping = (DirectCollectionMapping)empDescriptor.getMappingForAttributeName("responsibilitiesList");
        String oldReferenceTableName = dcmapping.getReferenceTableName();
        List oldDCHistoricalTableNames = dcmapping.getHistoryPolicy().getHistoryTableNames();
        dcmapping.getHistoryPolicy().setHistoricalTables(new Vector(1));
        for (int i = 0; i < oldDCHistoricalTableNames.size(); ++i) {
            dcmapping.getHistoryPolicy().addHistoryTableName(user + "." + oldDCHistoricalTableNames.get(i));
        }
        dcmapping.setReferenceTableName(user + "." + oldReferenceTableName);
        return initialProject;
    }

    @Override
    public void createTables(DatabaseSession session) {
        super.createTables(session);
        EmployeeTableCreator creator = new EmployeeTableCreator();
        HistoryFacade.generateHistoricalTableDefinitions((TableCreator)creator, (Session)session);
        creator.replaceTables(session);
    }
}

