/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.sequencing.SeqTestClass2;

public class SequenceStringPKInsertTest
extends AutoVerifyTestCase {
    public static final String TEST_NAME = "SequenceStringPKInsertTest";
    SeqTestClass2 testObject;
    Exception storedException;

    public SequenceStringPKInsertTest() {
        this.setDescription("Tests that objects with String Primary Keys are assigned sequence numbers.");
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void setup() {
        if (!(this.getSession().getPlatform().isOracle() || this.getSession().getPlatform().isMySQL() || this.getSession().getPlatform().isSymfoware())) {
            throw new TestWarningException("Database does do not support inserting a numeric value into a String column.");
        }
        this.beginTransaction();
        this.storedException = null;
        this.testObject = new SeqTestClass2();
        this.testObject.setTest1("Sequence Test Object");
        this.testObject.setTest2(TEST_NAME);
    }

    protected void test() {
        try {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            uow.registerObject((Object)this.testObject);
            uow.assignSequenceNumbers();
            uow.commit();
        }
        catch (Exception e) {
            this.setStoredException((Exception)((Object)new TestErrorException("Unable to assign String sequence number in test:SequenceStringPKInsertTest")));
            return;
        }
    }

    protected void verify() throws Exception {
        if (this.storedException != null) {
            throw this.storedException;
        }
    }

    protected void setStoredException(Exception e) {
        if (this.storedException == null) {
            this.storedException = e;
        }
    }
}

