/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.events;

import java.util.Vector;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;

public abstract class AboutToInsertEventTest
extends TestCase {
    protected Object objectToInsert = null;
    protected Accessor writeConnection = null;
    protected boolean isMultithreaded = false;

    public AboutToInsertEventTest(Object objectToInsert, boolean isMultithreaded) {
        this.objectToInsert = objectToInsert;
        this.isMultithreaded = isMultithreaded;
    }

    public abstract String getSQLVerificationString();

    public void setup() {
        if (this.getSession().getDescriptor(this.objectToInsert.getClass()).isPrimaryKeySetAfterInsert(this.getAbstractSession())) {
            throw new TestWarningException("This test can't run because the primary key is set into the object after INSERT ");
        }
        if (!this.isMultithreaded) {
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
        this.beginTransaction();
        if (this.isMultithreaded) {
            this.writeConnection = this.getAbstractSession().getAccessor();
        }
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerNewObject(this.objectToInsert);
        uow.commit();
    }

    public void verify() {
        Vector result;
        DataReadQuery query = new DataReadQuery(this.getSQLVerificationString());
        if (this.isMultithreaded) {
            query.setAccessor(this.writeConnection);
        }
        if ((result = (Vector)this.getSession().executeQuery((DatabaseQuery)query)) == null || result.isEmpty()) {
            throw new TestErrorException("The query was not updated in the aboutToInsertEvent");
        }
    }

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.rollbackTransaction();
        }
        this.writeConnection = null;
        if (!this.isMultithreaded) {
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }
}

