/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.tests.distributedservers.Company;
import org.eclipse.persistence.testing.tests.distributedservers.Dist_Employee;
import org.eclipse.persistence.testing.tests.distributedservers.Item;

public class DistributedProject
extends Project {
    public DistributedProject() {
        this.setName("DistributedProject");
        this.applyLogin();
        this.addDescriptor((ClassDescriptor)this.buildCompanyDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildDist_EmployeeDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildItemDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        this.setLogin(login);
    }

    public RelationalDescriptor buildCompanyDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Company.class);
        descriptor.addTableName("DIST_COMPANY");
        descriptor.addPrimaryKeyFieldName("DIST_COMPANY.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("DIST_COMPANY.ID");
        descriptor.setSequenceNumberName("COMAPNY_SEQ");
        descriptor.setAlias("Company");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("DIST_COMPANY.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("DIST_COMPANY.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToManyMapping ownedItemsMapping = new OneToManyMapping();
        ownedItemsMapping.setAttributeName("ownedItems");
        ownedItemsMapping.setReferenceClass(Item.class);
        ownedItemsMapping.dontUseIndirection();
        ownedItemsMapping.useCollectionClass(Vector.class);
        ownedItemsMapping.addTargetForeignKeyFieldName("DIST_ITEM.COMPANYOWNER", "DIST_COMPANY.ID");
        descriptor.addMapping((DatabaseMapping)ownedItemsMapping);
        return descriptor;
    }

    public RelationalDescriptor buildDist_EmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Dist_Employee.class);
        descriptor.addTableName("DIST_EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("DIST_EMPLOYEE.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("DIST_EMPLOYEE.ID");
        descriptor.setSequenceNumberName("EMPLOYEE_SEQ");
        descriptor.setAlias("Dist_Employee");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("DIST_EMPLOYEE.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("DIST_EMPLOYEE.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToManyMapping heldItemsMapping = new OneToManyMapping();
        heldItemsMapping.setAttributeName("heldItems");
        heldItemsMapping.setReferenceClass(Item.class);
        heldItemsMapping.dontUseIndirection();
        heldItemsMapping.useCollectionClass(Vector.class);
        heldItemsMapping.addTargetForeignKeyFieldName("DIST_ITEM.EMPLOYEEHOLDER", "DIST_EMPLOYEE.ID");
        descriptor.addMapping((DatabaseMapping)heldItemsMapping);
        return descriptor;
    }

    public RelationalDescriptor buildItemDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Item.class);
        descriptor.addTableName("DIST_ITEM");
        descriptor.addPrimaryKeyFieldName("DIST_ITEM.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("DIST_ITEM.ID");
        descriptor.setSequenceNumberName("ITEM_SEQ");
        descriptor.setAlias("Item");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("DIST_ITEM.DESCRIPTION");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("DIST_ITEM.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        OneToOneMapping companyOwnerMapping = new OneToOneMapping();
        companyOwnerMapping.setAttributeName("companyOwner");
        companyOwnerMapping.setReferenceClass(Company.class);
        companyOwnerMapping.dontUseIndirection();
        companyOwnerMapping.addForeignKeyFieldName("DIST_ITEM.COMPANYOWNER", "DIST_COMPANY.ID");
        descriptor.addMapping((DatabaseMapping)companyOwnerMapping);
        OneToOneMapping employeeHolderMapping = new OneToOneMapping();
        employeeHolderMapping.setAttributeName("employeeHolder");
        employeeHolderMapping.setReferenceClass(Dist_Employee.class);
        employeeHolderMapping.dontUseIndirection();
        employeeHolderMapping.addForeignKeyFieldName("DIST_ITEM.EMPLOYEEHOLDER", "DIST_EMPLOYEE.ID");
        descriptor.addMapping((DatabaseMapping)employeeHolderMapping);
        return descriptor;
    }
}

