/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedcache;

import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Child;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.distributedcache.OrderedListMergeTest;

public class OrderedListMergeTest3
extends OrderedListMergeTest {
    Child childtoremove;

    @Override
    protected void modifyCollection(UnitOfWork uow, Object objectToModify) {
        Child newChildWC = (Child)uow.registerNewObject(this.newItemForCollection());
        ((Employee)objectToModify).children.set(0, newChildWC);
        newChildWC.parent = (Employee)objectToModify;
        this.childtoremove = (Child)((Employee)objectToModify).children.remove(1);
    }

    @Override
    protected void test() {
        ClientSession clientSession1 = this.cluster1Session.acquireClientSession();
        ClientSession clientSession2 = this.cluster2Session.acquireClientSession();
        this.cluster2Session.getIdentityMapAccessor().initializeAllIdentityMaps();
        this.cluster2Session.getEventManager().addListener(this.buildCacheMergeBlockingListener());
        Object object1 = this.findOriginalObject((Session)clientSession1);
        if (object1 == null) {
            throw new TestErrorException("Employee does not exist on Server 1");
        }
        int initialNumProjs = this.getCollectionSize(object1);
        Object object2 = this.findOriginalObject((Session)clientSession2);
        if (object2 == null) {
            throw new TestErrorException("Employee does not exist on Server 2");
        }
        this.getCollectionSize(object2);
        UnitOfWork uow = clientSession1.acquireUnitOfWork();
        Object newEmpWC = uow.registerObject(object1);
        this.modifyCollection(uow, newEmpWC);
        semaphore.acquire();
        uow.commit();
        try {
            while (semaphore.getNumberOfWritersWaiting() == 0) {
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            throw new TestErrorException("Error while getting Thread to sleep", (Throwable)e);
        }
        semaphore.release();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            throw new TestErrorException("Error while getting Thread to sleep", (Throwable)e);
        }
        semaphore.acquire();
        if (this.getCollectionSize(object1) != this.getCollectionSize(object2)) {
            throw new TestErrorException("Size of the collections do not match, expected " + this.getCollectionSize(object1) + " got " + this.getCollectionSize(object2));
        }
        if (!this.compareObjectsCollections(object1, object2)) {
            throw new TestErrorException("order does not match what is expected");
        }
        semaphore.release();
    }
}

