/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.conversion;

import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class ConvertByteCharArrayToStringTest
extends AutoVerifyTestCase {
    String hexString = Helper.buildHexStringFromBytes((byte[])new byte[]{1, 56, -128, 127});
    String testString = "A test string";
    byte[] byteArray;
    Byte[] byteOArray;
    char[] charArray;
    Character[] charOArray;
    String byteString;
    String byteOString;
    String charString;
    String charOString;

    public ConvertByteCharArrayToStringTest() {
        this.setDescription("Test if byte[], Byte[], char[] and Character[] are converted to String correctly.");
    }

    public void setup() {
        this.byteArray = (byte[])ConversionManager.getDefaultManager().convertObject((Object)this.hexString, ClassConstants.APBYTE);
        this.byteOArray = (Byte[])ConversionManager.getDefaultManager().convertObject((Object)this.hexString, ClassConstants.ABYTE);
        this.charArray = (char[])ConversionManager.getDefaultManager().convertObject((Object)this.testString, ClassConstants.APCHAR);
        this.charOArray = (Character[])ConversionManager.getDefaultManager().convertObject((Object)this.testString, ClassConstants.ACHAR);
    }

    public void test() {
        this.byteString = (String)ConversionManager.getDefaultManager().convertObject((Object)this.byteArray, ClassConstants.STRING);
        this.byteOString = (String)ConversionManager.getDefaultManager().convertObject((Object)this.byteOArray, ClassConstants.STRING);
        this.charString = (String)ConversionManager.getDefaultManager().convertObject((Object)this.charArray, ClassConstants.STRING);
        this.charOString = (String)ConversionManager.getDefaultManager().convertObject((Object)this.charOArray, ClassConstants.STRING);
    }

    public void verify() {
        if (!this.byteString.equals(this.hexString)) {
            throw new TestErrorException("Conversion of string to byte[] then to string failed.  The original string is" + this.hexString + ", the returned string is " + this.byteString);
        }
        if (!this.byteOString.equals(this.hexString)) {
            throw new TestErrorException("Conversion of string to Byte[] then to string failed.  The original string is" + this.hexString + ", the returned string is " + this.byteOString);
        }
        if (!this.charString.equals(this.testString)) {
            throw new TestErrorException("Conversion of string to char[] then to string failed.  The original string is" + this.testString + ", the returned string is " + this.charString);
        }
        if (!this.charOString.equals(this.testString)) {
            throw new TestErrorException("Conversion of string to Character[] then to string failed.  The original string is" + this.testString + ", the returned string is " + this.charOString);
        }
    }
}

