/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import java.io.IOException;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class ConcurrentBatchReadingTest
extends TestCase {
    public static int numThreads = 8;
    public boolean isCheckerThread;
    public static Server server;
    public static boolean execute;
    public static Thread[] threadList;
    public static long[] timeList;
    public static long runTime;
    public int index;

    public ConcurrentBatchReadingTest(long runtime) {
        this.setDescription("Test Simulates a highly concurrent situation with ReadLocks");
        runTime = runtime;
    }

    protected ConcurrentBatchReadingTest(boolean checkerThread, int index) {
        this.isCheckerThread = checkerThread;
        this.index = index;
    }

    public void reset() {
        execute = false;
        for (int count = 0; count < numThreads; ++count) {
            try {
                threadList[count].join();
                continue;
            }
            catch (InterruptedException ex) {
                throw new TestProblemException("Test thread was interrupted.  Test failed to run properly");
            }
        }
        server.logout();
    }

    public void setup() {
        block5: {
            execute = true;
            try {
                this.getSession().getLog().write("WARNING, some tests may take 3 minutes or more");
                this.getSession().getLog().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                DatabaseLogin login = (DatabaseLogin)this.getSession().getLogin().clone();
                server = new Server(login, numThreads, numThreads + 2);
                ConcurrentBatchReadingTest.server.serverSession.setLogLevel(this.getSession().getLogLevel());
                ConcurrentBatchReadingTest.server.serverSession.setLog(this.getSession().getLog());
                ConcurrentBatchReadingTest.server.serverSession.getEventManager().addListener((org.eclipse.persistence.sessions.SessionEventListener)new SessionEventListener());
                server.login();
                server.copyDescriptors(this.getSession());
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block5;
                this.verify();
            }
        }
        for (int count = 0; count < numThreads; ++count) {
            ConcurrentBatchReadingTest.threadList[count] = new Thread(new ConcurrentBatchReadingTest(false, count).runnable());
            ConcurrentBatchReadingTest.timeList[count] = System.currentTimeMillis();
        }
    }

    public void test() {
        for (int count = 0; count < numThreads; ++count) {
            threadList[count].start();
        }
        Thread checker = new Thread(new ConcurrentBatchReadingTest(true, -1).runnable());
        checker.start();
        try {
            checker.join();
        }
        catch (InterruptedException ex) {
            throw new TestProblemException("Test thread was interrupted.  Test failed to run properly");
        }
    }

    public void verify() {
        if (!execute) {
            for (int count = 0; count < numThreads; ++count) {
                threadList[count].stop();
            }
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            throw new TestErrorException("This test took too long to run.  see bug 3124136");
        }
    }

    public Runnable runnable() {
        return new Runnable(){

            @Override
            public void run() {
                if (ConcurrentBatchReadingTest.this.isCheckerThread) {
                    ConcurrentBatchReadingTest.this.watchOtherThreads();
                } else {
                    ConcurrentBatchReadingTest.this.executeUntilStopped();
                }
            }
        };
    }

    public void watchOtherThreads() {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < runTime + 30000L && execute) {
            for (int localIdex = 0; localIdex < numThreads; ++localIdex) {
                if (System.currentTimeMillis() - timeList[localIdex] <= 30000L) continue;
                execute = false;
                break;
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                throw new TestProblemException("Test thread was interrupted.  Test failed to run properly");
            }
        }
    }

    public void executeUntilStopped() {
        ClientSession session = ConcurrentBatchReadingTest.server.serverSession.acquireClientSession();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("managedEmployees").get("lastName").like("%o%");
        Expression exp2 = builder.anyOf("managedEmployees").get("firstName").like("%a%");
        while (execute) {
            ReadAllQuery query = new ReadAllQuery(Employee.class);
            query.setShouldRefreshIdentityMapResult(true);
            if (this.index % 2 == 0) {
                query.setSelectionCriteria(expression);
            } else {
                query.setSelectionCriteria(exp2);
            }
            query.addBatchReadAttribute("phoneNumbers");
            session = ConcurrentBatchReadingTest.server.serverSession.acquireClientSession();
            Vector vector = (Vector)session.executeQuery((DatabaseQuery)query);
            Employee emp = (Employee)vector.get(this.index % vector.size());
            emp.getPhoneNumbers();
            ConcurrentBatchReadingTest.timeList[this.index] = System.currentTimeMillis();
        }
    }

    static {
        execute = true;
        threadList = new Thread[numThreads];
        timeList = new long[numThreads];
    }

    class SessionEventListener
    extends SessionEventAdapter {
        public void postExecuteQuery(SessionEvent event) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

