/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.onetoonejointable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.testing.models.onetoonejointable.Employee;

public abstract class Project
implements Serializable,
ChangeTracker {
    public BigDecimal id;
    public String name = "";
    public String description = "";
    public ValueHolderInterface teamLeader = new ValueHolder();
    public PropertyChangeListener listener;
    public List<Employee> employees = new ArrayList<Employee>();

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    public void propertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listener != null && oldValue != newValue) {
            this.listener.propertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        }
    }

    public void collectionChange(String propertyName, Object oldValue, Object newValue, int changeType, boolean isChangeApplied) {
        if (this.listener != null) {
            this.listener.propertyChange((PropertyChangeEvent)new CollectionChangeEvent((Object)this, propertyName, oldValue, newValue, changeType, isChangeApplied));
        }
    }

    public Project() {
    }

    public Project(String name) {
        this();
        this.name = name;
    }

    public void addEmployee(Employee employee) {
        this.getEmployees().add(employee);
        employee.getProjects().add(this);
    }

    public String getDescription() {
        return this.description;
    }

    public BigDecimal getId() {
        return this.id;
    }

    public List<Employee> getEmployees() {
        return this.employees;
    }

    public String getName() {
        return this.name;
    }

    public Employee getTeamLeader() {
        return (Employee)this.teamLeader.getValue();
    }

    public void removeEmployee(Employee employee) {
        this.getEmployees().remove(employee);
        employee.getProjects().remove(this);
    }

    public void setDescription(String description) {
        this.propertyChange("description", this.description, description);
        this.description = description;
    }

    public void setId(BigDecimal id) {
        this.propertyChange("id", this.id, id);
        this.id = id;
    }

    public void setName(String name) {
        this.propertyChange("name", this.name, name);
        this.name = name;
    }

    public void setTeamLeader(Employee teamLeader) {
        this.propertyChange("teamLeader", this.teamLeader.getValue(), teamLeader);
        this.teamLeader.setValue((Object)teamLeader);
    }

    public void setEmployees(List<Employee> employees) {
        this.propertyChange("employees", this.employees, employees);
        this.employees = employees;
    }
}

