/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.inheritance;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.models.inheritance.Company;
import org.eclipse.persistence.tools.schemaframework.ViewDefinition;

public class Vehicle
implements Serializable {
    public Number id;
    public ValueHolderInterface owner = new ValueHolder();
    public Integer passengerCapacity;
    public Vector partNumbers = new Vector();

    public void addPartNumber(String aPartNumber) {
        this.partNumbers.addElement(aPartNumber);
    }

    public void change() {
    }

    public ValueHolderInterface getOwner() {
        return this.owner;
    }

    public static ViewDefinition oracleView() {
        ViewDefinition definition = new ViewDefinition();
        definition.setName("AllVehicles");
        definition.setSelectClause("Select V.*, F.FUEL_CAP, F.FUEL_TYP, B.DESCRIP, B.DRIVER_ID, C.CDESCRIP from VEHICLE V, FUEL_VEH F, BUS B, CAR C where V.ID = F.ID (+) AND V.ID = B.ID (+) AND V.ID = C.ID (+)");
        return definition;
    }

    public void setOwner(Company ownerCompany) {
        this.owner.setValue((Object)ownerCompany);
    }

    public void setPassengerCapacity(Integer capacity) {
        this.passengerCapacity = capacity;
    }

    public static ViewDefinition sybaseView() {
        ViewDefinition definition = new ViewDefinition();
        definition.setName("AllVehicles");
        definition.setSelectClause("Select V.*, F.FUEL_CAP, F.FUEL_TYP, B.DESCRIP, B.DRIVER_ID, C.CDESCRIP from VEHICLE V, FUEL_VEH F, BUS B, CAR C where V.ID *= F.ID AND V.ID *= B.ID AND V.ID *= C.ID");
        return definition;
    }

    public static ViewDefinition mySQLView() {
        ViewDefinition definition = new ViewDefinition();
        definition.setName("AllVehicles");
        definition.setSelectClause("Select V.*, F.FUEL_CAP, F.FUEL_TYP, B.DESCRIP, B.DRIVER_ID, C.CDESCRIP from VEHICLE V left join FUEL_VEH F on V.ID = F.ID left join BUS B on V.ID = B.ID left join CAR C on V.ID = C.ID");
        return definition;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.id + ")";
    }
}

