/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance.writing;

import javax.persistence.EntityManager;
import org.eclipse.persistence.testing.framework.PerformanceRegressionTestCase;
import org.eclipse.persistence.testing.models.jpa.performance2.Address;
import org.eclipse.persistence.testing.models.jpa.performance2.Employee;
import org.eclipse.persistence.testing.models.jpa.performance2.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.performance2.Gender;
import org.eclipse.persistence.testing.models.jpa.performance2.JobTitle;
import org.eclipse.persistence.testing.models.jpa.performance2.PhoneNumber;

public class JPA2MassInsertEmployeePerformanceComparisonTest
extends PerformanceRegressionTestCase {
    public JPA2MassInsertEmployeePerformanceComparisonTest() {
        this.setDescription("This test compares the performance of insert Employee.");
    }

    public void reset() {
        EntityManager manager = this.createEntityManager();
        manager.getTransaction().begin();
        manager.createQuery("Delete from Email where address = 'ceo@foo.com'").executeUpdate();
        manager.createQuery("Delete from Degree where name = 'HighSchool'").executeUpdate();
        manager.createQuery("Delete from PhoneNumber where number = '9991111'").executeUpdate();
        manager.createQuery("Delete from Employee where firstName = 'NewGuy'").executeUpdate();
        manager.createQuery("Delete from Address where street = 'Hasting Perf'").executeUpdate();
        manager.createQuery("Delete from JobTitle where name = 'CEO'").executeUpdate();
        manager.getTransaction().commit();
        manager.close();
    }

    public void test() throws Exception {
        EntityManager manager = this.createEntityManager();
        manager.getTransaction().begin();
        for (int index = 0; index < 50; ++index) {
            Employee empInsert = new Employee();
            empInsert.setFirstName("NewGuy");
            empInsert.setGender(Gender.Male);
            empInsert.setLastName("Doe");
            empInsert.setSalary(100000.0);
            EmploymentPeriod employmentPeriod = new EmploymentPeriod();
            employmentPeriod.setEndDate(1895, 1, 1);
            employmentPeriod.setStartDate(1901, 12, 31);
            empInsert.setPeriod(employmentPeriod);
            empInsert.setAddress(new Address());
            empInsert.getAddress().setCity("Nepean");
            empInsert.getAddress().setPostalCode("N5J2N5");
            empInsert.getAddress().setProvince("ON");
            empInsert.getAddress().setStreet("Hasting Perf");
            empInsert.getAddress().setCountry("Canada");
            empInsert.addPhoneNumber(new PhoneNumber("Work Fax", "613", "9991111"));
            empInsert.addPhoneNumber(new PhoneNumber("Home", "613", "9991111"));
            empInsert.setJobTitle(new JobTitle("CEO"));
            empInsert.addDegree("HighSchool");
            empInsert.addEmailAddress("work", "ceo@foo.com");
            empInsert.addResponsibility("code");
            manager.persist((Object)empInsert);
        }
        manager.getTransaction().commit();
        manager.close();
    }
}

