/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance.writing;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.persistence.testing.framework.PerformanceRegressionTestCase;
import org.eclipse.persistence.testing.models.jpa.performance2.Address;
import org.eclipse.persistence.testing.models.jpa.performance2.Employee;
import org.eclipse.persistence.testing.models.jpa.performance2.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.performance2.Gender;
import org.eclipse.persistence.testing.models.jpa.performance2.JobTitle;
import org.eclipse.persistence.testing.models.jpa.performance2.PhoneNumber;

public class JPA2InsertDeleteEmployeePerformanceComparisonTest
extends PerformanceRegressionTestCase {
    public JPA2InsertDeleteEmployeePerformanceComparisonTest() {
        this.setDescription("This test compares the performance of insert Employee.");
    }

    public void setup() {
        EntityManager manager = this.createEntityManager();
        Employee any = (Employee)manager.createQuery("Select e from Employee e").getResultList().get(0);
        Query query = manager.createQuery("Select e from Employee e where e.id = :id");
        query.setParameter("id", (Object)new Long(any.getId()));
        any = (Employee)query.getSingleResult();
        manager.close();
        manager = this.createEntityManager();
        any = (Employee)manager.find(Employee.class, (Object)any.getId());
        manager.close();
    }

    public void test() throws Exception {
        EntityManager manager = this.createEntityManager();
        manager.getTransaction().begin();
        Employee employee = new Employee();
        employee.setFirstName("NewGuy");
        employee.setGender(Gender.Male);
        employee.setLastName("Doe");
        employee.setSalary(100000.0);
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(1895, 1, 1);
        employmentPeriod.setStartDate(1901, 12, 31);
        employee.setPeriod(employmentPeriod);
        employee.setAddress(new Address());
        employee.getAddress().setCity("Nepean");
        employee.getAddress().setPostalCode("N5J2N5");
        employee.getAddress().setProvince("ON");
        employee.getAddress().setStreet("Hasting Perf");
        employee.getAddress().setCountry("Canada");
        employee.addPhoneNumber(new PhoneNumber("Work Fax", "613", "9991111"));
        employee.addPhoneNumber(new PhoneNumber("Home", "613", "9991111"));
        employee.setJobTitle(new JobTitle("CEO"));
        employee.addDegree("HighSchool");
        employee.addEmailAddress("work", "ceo@foo.com");
        employee.addResponsibility("code");
        manager.persist((Object)employee);
        manager.getTransaction().commit();
        manager.close();
        manager = this.createEntityManager();
        manager.getTransaction().begin();
        employee = (Employee)manager.getReference(Employee.class, (Object)new Long(employee.getId()));
        manager.remove((Object)employee);
        manager.getTransaction().commit();
        manager.close();
    }
}

