/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.TemporalType;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.datetime.DateTimePopulator;
import org.eclipse.persistence.testing.models.jpa.datetime.DateTimeTableCreator;

public class JUnitJPQLDateTimeTestSuite
extends JUnitTestCase {
    public JUnitJPQLDateTimeTestSuite() {
    }

    public JUnitJPQLDateTimeTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitJPQLDateTimeTestSuite");
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testSetup"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testSqlDate"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testSqlDateToTS"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testTime"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testTimeToTS"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testTimestamp"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testTimestampToDate"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testTimestampToTime"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testUtilDate"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testCalenderWithUtilDate"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testSqlDateWithCal"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testTimeWithCal"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testTimestampWithCal"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testCalendar"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testTimestampGreaterThan"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testTimestampLessThan"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testTimestampIn"));
        suite.addTest((Test)new JUnitJPQLDateTimeTestSuite("testTimestampBetween"));
        return suite;
    }

    public void testSetup() {
        new DateTimeTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        DateTimePopulator dateTimePopulator = new DateTimePopulator();
        dateTimePopulator.persistExample((Session)JUnitJPQLDateTimeTestSuite.getServerSession());
        this.clearCache();
    }

    public void testSqlDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.date = :date").setParameter("date", cal.getTime(), TemporalType.DATE).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be one result", (result.size() == 1 ? 1 : 0) != 0);
    }

    public void testSqlDateToTS() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.date = :date").setParameter("date", cal.getTime(), TemporalType.TIMESTAMP).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be one result", (result.size() == 1 ? 1 : 0) != 0);
    }

    public void testTime() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.time = :time").setParameter("time", cal.getTime(), TemporalType.TIME).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be one result", (result.size() == 1 ? 1 : 0) != 0);
    }

    public void testTimeToTS() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.time = :time").setParameter("time", cal.getTime(), TemporalType.TIMESTAMP).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be one result", (result.size() == 1 ? 1 : 0) != 0);
    }

    public void testTimestamp() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.timestamp = :timestamp").setParameter("timestamp", cal.getTime(), TemporalType.TIMESTAMP).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be one result", (result.size() == 1 ? 1 : 0) != 0);
    }

    public void testTimestampToDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.timestamp = :timestamp").setParameter("timestamp", cal.getTime(), TemporalType.DATE).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be zero result", (result.size() == 0 ? 1 : 0) != 0);
    }

    public void testTimestampToTime() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.timestamp = :timestamp").setParameter("timestamp", cal.getTime(), TemporalType.TIME).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be zero result", (result.size() == 0 ? 1 : 0) != 0);
    }

    public void testUtilDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.utilDate = :utilDate").setParameter("utilDate", cal.getTime(), TemporalType.TIMESTAMP).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be one result", (result.size() == 1 ? 1 : 0) != 0);
    }

    public void testCalenderWithUtilDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.calendar = :calendar").setParameter("calendar", cal.getTime(), TemporalType.TIMESTAMP).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be one result", (result.size() == 1 ? 1 : 0) != 0);
    }

    public void testSqlDateWithCal() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.date = :date").setParameter("date", (Calendar)cal, TemporalType.DATE).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be one result", (result.size() == 1 ? 1 : 0) != 0);
    }

    public void testTimeWithCal() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.time = :time").setParameter("time", (Calendar)cal, TemporalType.TIME).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be one result", (result.size() == 1 ? 1 : 0) != 0);
    }

    public void testTimestampWithCal() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.timestamp = :timestamp").setParameter("timestamp", (Calendar)cal, TemporalType.TIMESTAMP).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be one result", (result.size() == 1 ? 1 : 0) != 0);
    }

    public void testUtilDateWithCal() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.utilDate = :utilDate").setParameter("utilDate", (Calendar)cal, TemporalType.TIMESTAMP).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be one result", (result.size() == 1 ? 1 : 0) != 0);
    }

    public void testCalendar() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.calendar = :calendar").setParameter("calendar", (Calendar)cal, TemporalType.TIMESTAMP).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be one result", (result.size() == 1 ? 1 : 0) != 0);
    }

    public void testTimestampGreaterThan() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.timestamp > :timestamp").setParameter("timestamp", cal.getTime(), TemporalType.TIMESTAMP).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be three result", (result.size() == 3 ? 1 : 0) != 0);
    }

    public void testTimestampLessThan() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(2001, 6, 1, 3, 45, 32);
        cal.set(14, 87);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.timestamp < :timestamp").setParameter("timestamp", cal.getTime(), TemporalType.TIMESTAMP).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be three result", (result.size() == 2 ? 1 : 0) != 0);
    }

    public void testTimestampIn() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.set(2001, 6, 1, 3, 45, 32);
        cal2.set(14, 87);
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.timestamp IN (:timestamp1, :timestamp2)").setParameter("timestamp1", cal.getTime(), TemporalType.TIMESTAMP).setParameter("timestamp2", (Calendar)cal2, TemporalType.TIMESTAMP).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be two result", (result.size() == 2 ? 1 : 0) != 0);
    }

    public void testTimestampBetween() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1901, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        Calendar cal2 = Calendar.getInstance();
        List result = this.createEntityManager().createQuery("SELECT OBJECT(o) FROM DateTime o WHERE o.timestamp BETWEEN :timestamp1 AND :timestamp2").setParameter("timestamp1", cal.getTime(), TemporalType.TIMESTAMP).setParameter("timestamp2", cal2, TemporalType.TIMESTAMP).getResultList();
        JUnitJPQLDateTimeTestSuite.assertTrue((String)"There should be four result", (result.size() == 4 ? 1 : 0) != 0);
    }
}

