/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inheritance;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.JoinedAttributeTestHelper;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.inheritance.Company;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceModelExamples;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.models.jpa.inheritance.Vehicle;

public class JoinedAttributeInheritanceJunitTest
extends JUnitTestCase {
    protected static Class[] classes = new Class[]{Company.class, Vehicle.class};
    protected static Vector[] objectVectors = new Vector[]{null, null};
    protected DatabaseSession dbSession;

    public JoinedAttributeInheritanceJunitTest() {
    }

    public JoinedAttributeInheritanceJunitTest(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.dbSessionClearCache();
        if (!this.compare()) {
            this.clear();
            this.populate();
        }
        this.dbSessionClearCache();
    }

    protected DatabaseSession getDbSession() {
        if (this.dbSession == null) {
            this.dbSession = JoinedAttributeInheritanceJunitTest.getServerSession();
        }
        return this.dbSession;
    }

    protected UnitOfWork acquireUnitOfWork() {
        return this.getDbSession().acquireUnitOfWork();
    }

    protected void clear() {
        UnitOfWork uow = this.acquireUnitOfWork();
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Vehicle.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Company.class));
        uow.commit();
        this.dbSessionClearCache();
    }

    protected void populate() {
        UnitOfWork uow = this.acquireUnitOfWork();
        uow.registerNewObject((Object)InheritanceModelExamples.companyExample1());
        uow.registerNewObject((Object)InheritanceModelExamples.companyExample2());
        uow.registerNewObject((Object)InheritanceModelExamples.companyExample3());
        uow.commit();
        this.dbSessionClearCache();
        for (int i = 0; i < classes.length; ++i) {
            JoinedAttributeInheritanceJunitTest.objectVectors[i] = this.getDbSession().readAllObjects(classes[i]);
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(JoinedAttributeInheritanceJunitTest.class);
        return suite;
    }

    public void testSetup() {
        new InheritanceTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void tearDown() {
        this.dbSessionClearCache();
        this.dbSession = null;
        super.tearDown();
    }

    public void testVehicleJoinCompany() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Vehicle.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(query.getExpressionBuilder().get("owner"));
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeInheritanceJunitTest.fail((String)errorMsg);
        }
    }

    public void testVehicleJoinCompanyWherePassengerCapacity() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Vehicle.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("passengerCapacity").greaterThan(2));
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(query.getExpressionBuilder().get("owner"));
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeInheritanceJunitTest.fail((String)errorMsg);
        }
    }

    public void testCompanyJoinVehicles() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Company.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(query.getExpressionBuilder().anyOf("vehicles"));
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeInheritanceJunitTest.fail((String)errorMsg);
        }
    }

    public void testCompanyJoinVehiclesWhereNameTOP() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Company.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("name").equal((Object)"TOP"));
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(query.getExpressionBuilder().anyOf("vehicles"));
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            JoinedAttributeInheritanceJunitTest.fail((String)errorMsg);
        }
    }

    protected String executeQueriesAndCompareResults(ObjectLevelReadQuery controlQuery, ObjectLevelReadQuery queryWithJoins) {
        return JoinedAttributeTestHelper.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)queryWithJoins, (AbstractSession)((AbstractSession)this.getDbSession()));
    }

    protected boolean compare() {
        for (int i = 0; i < classes.length; ++i) {
            if (this.compare(i)) continue;
            return false;
        }
        return true;
    }

    protected boolean compare(int i) {
        if (objectVectors[i] == null) {
            return false;
        }
        Vector currentVector = this.getDbSession().readAllObjects(classes[i]);
        if (currentVector.size() != objectVectors[i].size()) {
            return false;
        }
        ClassDescriptor descriptor = this.getDbSession().getDescriptor(classes[i]);
        for (int j = 0; j < currentVector.size(); ++j) {
            Object obj1 = objectVectors[i].elementAt(j);
            Object obj2 = currentVector.elementAt(j);
            if (descriptor.getObjectBuilder().compareObjects(obj1, obj2, (AbstractSession)this.getDbSession())) continue;
            return false;
        }
        return true;
    }

    public void dbSessionClearCache() {
        this.getDbSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

