/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.simple.mappings;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicTypeBuilder;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class SimpleTypes_ManyToMany {
    static EntityManagerFactory emf = null;
    static JPADynamicHelper helper = null;

    @BeforeClass
    public static void setUp() {
        emf = DynamicTestHelper.createEMF("dynamic");
        helper = new JPADynamicHelper(emf);
        DynamicClassLoader dcl = helper.getDynamicClassLoader();
        Class simpleTypeA = dcl.createDynamicClass("model.SimpleA");
        JPADynamicTypeBuilder aFactory = new JPADynamicTypeBuilder(simpleTypeA, null, new String[]{"SIMPLE_TYPE_A"});
        aFactory.setPrimaryKeyFields(new String[]{"SID"});
        Class simpleTypeB = dcl.createDynamicClass("model.SimpleB");
        JPADynamicTypeBuilder bFactory = new JPADynamicTypeBuilder(simpleTypeB, null, new String[]{"SIMPLE_TYPE_B"});
        bFactory.setPrimaryKeyFields(new String[]{"SID"});
        bFactory.addDirectMapping("id", Integer.TYPE, "SID");
        bFactory.addDirectMapping("value1", String.class, "VAL_1");
        bFactory.addOneToOneMapping("a", aFactory.getType(), new String[]{"A_FK"});
        aFactory.addDirectMapping("id", Integer.TYPE, "SID");
        aFactory.addDirectMapping("value1", String.class, "VAL_1");
        aFactory.addManyToManyMapping("b", bFactory.getType(), "SIMPLE_A_B");
        helper.addTypes(true, true, new DynamicType[]{aFactory.getType(), bFactory.getType()});
    }

    @AfterClass
    public static void tearDown() {
        if (emf != null && emf.isOpen()) {
            EntityManager em = emf.createEntityManager();
            em.getTransaction().begin();
            em.createNativeQuery("DROP TABLE SIMPLE_A_B").executeUpdate();
            em.createNativeQuery("DROP TABLE SIMPLE_TYPE_B").executeUpdate();
            em.createNativeQuery("DROP TABLE SIMPLE_TYPE_A").executeUpdate();
            em.getTransaction().commit();
            em.close();
            emf.close();
        }
    }

    @After
    public void clearDynamicTables() {
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.createNativeQuery("DELETE FROM SIMPLE_A_B").executeUpdate();
        em.createQuery("DELETE FROM SimpleB").executeUpdate();
        em.createQuery("DELETE FROM SimpleA").executeUpdate();
        em.getTransaction().commit();
        em.close();
    }

    @Test
    public void verifyConfig() throws Exception {
        ClassDescriptor descriptorA = helper.getSession().getClassDescriptorForAlias("SimpleA");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleA'", (Object)descriptorA);
        DynamicType simpleTypeA = helper.getType("SimpleA");
        Assert.assertNotNull((String)"'SimpleA' EntityType not found", (Object)simpleTypeA);
        Assert.assertEquals((Object)descriptorA, (Object)simpleTypeA.getDescriptor());
        DirectToFieldMapping a_id = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)a_id.getAttributeClassification());
        DirectToFieldMapping a_value1 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)a_value1.getAttributeClassification());
        ClassDescriptor descriptorB = helper.getSession().getClassDescriptorForAlias("SimpleB");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleB'", (Object)descriptorB);
        DynamicType simpleTypeB = helper.getType("SimpleB");
        Assert.assertNotNull((String)"'SimpleB' EntityType not found", (Object)simpleTypeB);
        Assert.assertEquals((Object)descriptorB, (Object)simpleTypeB.getDescriptor());
        DirectToFieldMapping b_id = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)b_id.getAttributeClassification());
        DirectToFieldMapping b_value1 = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)b_value1.getAttributeClassification());
        ManyToManyMapping a_b = (ManyToManyMapping)descriptorA.getMappingForAttributeName("b");
        Assert.assertEquals((Object)descriptorB, (Object)a_b.getReferenceDescriptor());
    }

    @Test
    public void createSimpleA() {
        DynamicType simpleTypeA = helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        EntityManager em = emf.createEntityManager();
        DynamicEntity simpleInstance = simpleTypeA.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"A1");
        em.getTransaction().begin();
        em.persist((Object)simpleInstance);
        em.getTransaction().commit();
        int simpleCount = ((Number)em.createQuery("SELECT COUNT(s) FROM SimpleA s").getSingleResult()).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
        em.close();
    }

    @Test
    public void createSimpleB() {
        DynamicType simpleTypeB = helper.getType("SimpleB");
        Assert.assertNotNull((Object)simpleTypeB);
        EntityManager em = emf.createEntityManager();
        DynamicEntity simpleInstance = simpleTypeB.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"B1");
        em.getTransaction().begin();
        em.persist((Object)simpleInstance);
        em.getTransaction().commit();
        int simpleCount = ((Number)em.createQuery("SELECT COUNT(s) FROM SimpleB s").getSingleResult()).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
        em.close();
    }

    @Test
    public void createAwithB() {
        DynamicType simpleTypeA = helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicType simpleTypeB = helper.getType("SimpleB");
        Assert.assertNotNull((Object)simpleTypeB);
        EntityManager em = emf.createEntityManager();
        Assert.assertNotNull((Object)JpaHelper.getServerSession((EntityManagerFactory)emf).getDescriptorForAlias("SimpleB"));
        DynamicEntity simpleInstanceB = simpleTypeB.newDynamicEntity();
        simpleInstanceB.set("id", (Object)1);
        simpleInstanceB.set("value1", (Object)"B2");
        DynamicEntity simpleInstanceA = simpleTypeA.newDynamicEntity();
        simpleInstanceA.set("id", (Object)1);
        simpleInstanceA.set("value1", (Object)"A2");
        ((Collection)simpleInstanceA.get("b")).add(simpleInstanceB);
        simpleInstanceB.set("a", (Object)simpleInstanceA);
        em.getTransaction().begin();
        em.persist((Object)simpleInstanceB);
        em.persist((Object)simpleInstanceA);
        em.getTransaction().commit();
        int simpleCountB = ((Number)em.createQuery("SELECT COUNT(s) FROM SimpleB s").getSingleResult()).intValue();
        Assert.assertEquals((long)1L, (long)simpleCountB);
        int simpleCountA = ((Number)em.createQuery("SELECT COUNT(s) FROM SimpleA s").getSingleResult()).intValue();
        Assert.assertEquals((long)1L, (long)simpleCountA);
        em.close();
    }

    @Test
    public void removeRelationshop() {
        DynamicType simpleTypeA = helper.getType("SimpleA");
        this.createAwithB();
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        DynamicEntity a = (DynamicEntity)em.find(simpleTypeA.getJavaClass(), (Object)1);
        Assert.assertNotNull((Object)a);
        List bs = (List)a.get("b");
        Assert.assertNotNull((Object)bs);
        Assert.assertEquals((long)1L, (long)bs.size());
        bs.remove(0);
        em.getTransaction().commit();
    }

    @Ignore
    public void createAwithExistingB() {
    }

    @Ignore
    public void addAtoB() {
    }
}

