/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.employee;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.queries.EntityFetchGroup;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.tests.jpa.config.ConfigPUTestSuite;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.eclipse.persistence.testing.tests.jpa.dynamic.QuerySQLTracker;
import org.eclipse.persistence.testing.tests.jpa.dynamic.employee.DynamicEmployeeSystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EmployeeSparseMergeTestSuite {
    static EntityManagerFactory emf = null;
    static JPADynamicHelper helper = null;
    static Server serverSession = null;
    static DynamicEmployeeSystem deSystem = null;
    static QuerySQLTracker qTracker = null;
    private static SessionLog log = null;

    private static void runCleanSequence(Server serverSession) throws DatabaseException {
        if (serverSession.getPlatform().isMySQL()) {
            serverSession.executeNonSelectingSQL("UPDATE EMPLOYEE_SEQ SET SEQ_COUNT = 0 WHERE SEQ_NAME = 'EMP_SEQ'");
        } else {
            serverSession.executeNonSelectingSQL("UPDATE SEQUENCE SET SEQ_COUNT = 0 WHERE SEQ_NAME = 'EMP_SEQ'");
        }
    }

    private static void initSequence(Server serverSession) throws DatabaseException {
        boolean retry = false;
        try {
            EmployeeSparseMergeTestSuite.runCleanSequence(serverSession);
            log.log(3, "SEQ_COUNT sequence already exists and was cleaned up.");
        }
        catch (DatabaseException ex) {
            log.log(3, "SEQ_COUNT 1st sequence cleanup attempt failed: " + ex.getMessage());
            retry = true;
        }
        if (retry) {
            log.log(3, "Running SEQ_COUNT sequence initialization.");
            ConfigPUTestSuite suite = new ConfigPUTestSuite();
            suite.setUp();
            suite.testCreateConfigPU();
            suite.testVerifyConfigPU();
            try {
                EmployeeSparseMergeTestSuite.runCleanSequence(serverSession);
                log.log(3, "SEQ_COUNT sequence cleaned up after being created.");
            }
            catch (DatabaseException ex) {
                log.log(6, "SEQ_COUNT sequence cleanup failed after initialization: " + ex.getMessage());
                throw ex;
            }
        }
    }

    @BeforeClass
    public static void setUp() throws Exception {
        emf = DynamicTestHelper.createEMF("dynamic");
        helper = new JPADynamicHelper(emf);
        deSystem = DynamicEmployeeSystem.buildProject((DynamicHelper)helper);
        serverSession = JpaHelper.getServerSession((EntityManagerFactory)emf);
        log = serverSession.getSessionLog();
        EmployeeSparseMergeTestSuite.initSequence(serverSession);
        deSystem.populate(helper, emf.createEntityManager());
        serverSession.getIdentityMapAccessor().initializeAllIdentityMaps();
        qTracker = QuerySQLTracker.install((Session)serverSession);
        serverSession.setLogLevel(3);
    }

    @AfterClass
    public static void tearDown() {
        serverSession.executeNonSelectingSQL("DELETE FROM D_PROJ_EMP");
        serverSession.executeNonSelectingSQL("DELETE FROM D_PHONE");
        serverSession.executeNonSelectingSQL("DELETE FROM D_SALARY");
        serverSession.executeNonSelectingSQL("DELETE FROM D_PROJECT");
        serverSession.executeNonSelectingSQL("DELETE FROM D_EMPLOYEE");
        serverSession.executeNonSelectingSQL("DELETE FROM D_ADDRESS");
        try {
            serverSession.executeNonSelectingSQL("DROP TABLE D_SALARY");
            serverSession.executeNonSelectingSQL("DROP TABLE D_PROJ_EMP");
            serverSession.executeNonSelectingSQL("DROP TABLE D_PROJECT");
            serverSession.executeNonSelectingSQL("DROP TABLE D_PHONE");
            serverSession.executeNonSelectingSQL("DROP TABLE D_EMPLOYEE");
            serverSession.executeNonSelectingSQL("DROP TABLE D_ADDRESS");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        helper = null;
        emf.close();
        emf = null;
        log = null;
    }

    @Test
    public void mergeSparseDynamicEntityWithFetchGroup() {
        EntityManager em = emf.createEntityManager();
        JPADynamicHelper helper = new JPADynamicHelper(em);
        DynamicType employeeType = helper.getType("Employee");
        DynamicEntity sparseEmployee = employeeType.newDynamicEntity();
        EntityFetchGroup efg = new EntityFetchGroup(new String[0]);
        ((FetchGroupTracker)sparseEmployee)._persistence_setFetchGroup((FetchGroup)efg);
        sparseEmployee.set("id", (Object)EmployeeSparseMergeTestSuite.minimumEmployeeId(em));
        sparseEmployee.set("firstName", (Object)"Mike");
        sparseEmployee.set("lastName", (Object)"Norman");
        sparseEmployee.set("salary", (Object)12345);
        em.getTransaction().begin();
        em.merge((Object)sparseEmployee);
        em.getTransaction().commit();
        Assert.assertEquals((String)"Incorrect # of UPDATE calls", (long)2L, (long)qTracker.getTotalSQLUPDATECalls());
    }

    public static int minimumEmployeeId(EntityManager em) {
        return ((Number)em.createQuery("SELECT MIN(e.id) FROM Employee e").getSingleResult()).intValue();
    }
}

