/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree.analysis;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

final class SmallSet<T>
extends AbstractSet<T> {
    private final T element1;
    private final T element2;

    SmallSet() {
        this.element1 = null;
        this.element2 = null;
    }

    SmallSet(T t) {
        this.element1 = t;
        this.element2 = null;
    }

    private SmallSet(T t, T t2) {
        this.element1 = t;
        this.element2 = t2;
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl<T>(this.element1, this.element2);
    }

    @Override
    public int size() {
        return this.element1 == null ? 0 : (this.element2 == null ? 1 : 2);
    }

    Set<T> union(SmallSet<T> smallSet) {
        if (smallSet.element1 == this.element1 && smallSet.element2 == this.element2 || smallSet.element1 == this.element2 && smallSet.element2 == this.element1) {
            return this;
        }
        if (smallSet.element1 == null) {
            return this;
        }
        if (this.element1 == null) {
            return smallSet;
        }
        if (smallSet.element2 == null) {
            if (this.element2 == null) {
                return new SmallSet<T>(this.element1, smallSet.element1);
            }
            if (smallSet.element1 == this.element1 || smallSet.element1 == this.element2) {
                return this;
            }
        }
        if (this.element2 == null && (this.element1 == smallSet.element1 || this.element1 == smallSet.element2)) {
            return smallSet;
        }
        HashSet<T> hashSet = new HashSet<T>(4);
        hashSet.add(this.element1);
        if (this.element2 != null) {
            hashSet.add(this.element2);
        }
        hashSet.add(smallSet.element1);
        if (smallSet.element2 != null) {
            hashSet.add(smallSet.element2);
        }
        return hashSet;
    }

    static class IteratorImpl<T>
    implements Iterator<T> {
        private T firstElement;
        private T secondElement;

        IteratorImpl(T t, T t2) {
            this.firstElement = t;
            this.secondElement = t2;
        }

        @Override
        public boolean hasNext() {
            return this.firstElement != null;
        }

        @Override
        public T next() {
            if (this.firstElement == null) {
                throw new NoSuchElementException();
            }
            T t = this.firstElement;
            this.firstElement = this.secondElement;
            this.secondElement = null;
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

