/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ExtendedListModel
extends AbstractListModel
implements ListModel {
    protected ListModel listModel;
    protected List prefix;
    protected List suffix;

    public ExtendedListModel(List prefix, ListModel listModel, List suffix) {
        this.initialize(listModel);
        this.prefix = new ArrayList(prefix);
        this.suffix = new ArrayList(suffix);
    }

    public ExtendedListModel(Object prefix, ListModel listModel, Object suffix) {
        this(Collections.singletonList(prefix), listModel, Collections.singletonList(suffix));
    }

    public ExtendedListModel(List prefix, ListModel listModel) {
        this(prefix, listModel, Collections.EMPTY_LIST);
    }

    public ExtendedListModel(Object prefix, ListModel listModel) {
        this(Collections.singletonList(prefix), listModel, Collections.EMPTY_LIST);
    }

    public ExtendedListModel(ListModel listModel, List suffix) {
        this(Collections.EMPTY_LIST, listModel, suffix);
    }

    public ExtendedListModel(ListModel listModel, Object suffix) {
        this(Collections.EMPTY_LIST, listModel, Collections.singletonList(suffix));
    }

    public ExtendedListModel(ListModel listModel) {
        this(Collections.singletonList(null), listModel, Collections.EMPTY_LIST);
    }

    protected void initialize(ListModel model) {
        this.listModel = model;
        this.listModel.addListDataListener(this.buildListDataListener());
    }

    protected ListDataListener buildListDataListener() {
        return new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                ExtendedListModel.this.intervalAdded(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ExtendedListModel.this.intervalRemoved(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ExtendedListModel.this.contentsChanged(e);
            }

            public String toString() {
                return "list data listener";
            }
        };
    }

    void intervalAdded(ListDataEvent e) {
        int prefixSize = this.prefix.size();
        this.fireIntervalAdded(this, e.getIndex0() + prefixSize, e.getIndex1() + prefixSize);
    }

    void intervalRemoved(ListDataEvent e) {
        int prefixSize = this.prefix.size();
        this.fireIntervalRemoved(this, e.getIndex0() + prefixSize, e.getIndex1() + prefixSize);
    }

    void contentsChanged(ListDataEvent e) {
        int prefixSize = this.prefix.size();
        int newIndex0 = e.getIndex0() == -1 ? -1 : e.getIndex0() + prefixSize;
        int newIndex1 = e.getIndex1() == -1 ? -1 : e.getIndex1() + prefixSize;
        this.fireContentsChanged(this, newIndex0, newIndex1);
    }

    @Override
    public int getSize() {
        return this.prefix.size() + this.listModel.getSize() + this.suffix.size();
    }

    public Object getElementAt(int index) {
        int prefixSize = this.prefix.size();
        if (index < prefixSize) {
            return this.prefix.get(index);
        }
        if (index >= prefixSize + this.listModel.getSize()) {
            return this.suffix.get(index - (prefixSize + this.listModel.getSize()));
        }
        return this.listModel.getElementAt(index - prefixSize);
    }
}

