/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeEvent;

public class ValueModelChangeSupport
extends ChangeSupport {
    private static final long serialVersionUID = 1L;

    public ValueModelChangeSupport(ValueModel source) {
        super((Object)source);
    }

    private UnsupportedOperationException unsupportedOperationException() {
        return new UnsupportedOperationException("ValueModels only support VALUE changes");
    }

    private void checkAspectName(String aspectName) {
        if (aspectName != "value") {
            throw new IllegalArgumentException("ValueModels only support VALUE changes: " + aspectName);
        }
    }

    protected void addListener(String aspectName, Class listenerClass, Object listener) {
        this.checkAspectName(aspectName);
        this.addListener(listenerClass, listener);
    }

    protected void removeListener(String aspectName, Class listenerClass, Object listener) {
        this.checkAspectName(aspectName);
        this.removeListener(listenerClass, listener);
    }

    protected boolean hasAnyListeners(Class listenerClass, String aspectName) {
        this.checkAspectName(aspectName);
        return this.hasAnyListeners(listenerClass);
    }

    public void fireStateChanged() {
        throw this.unsupportedOperationException();
    }

    public void fireStateChanged(StateChangeEvent event) {
        throw this.unsupportedOperationException();
    }

    public void firePropertyChanged(PropertyChangeEvent event) {
        this.checkAspectName(event.getPropertyName());
        super.firePropertyChanged(event);
    }

    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.checkAspectName(propertyName);
        super.firePropertyChanged(propertyName, oldValue, newValue);
    }

    public void firePropertyChanged(String propertyName, int oldValue, int newValue) {
        this.checkAspectName(propertyName);
        super.firePropertyChanged(propertyName, oldValue, newValue);
    }

    public void firePropertyChanged(String propertyName, boolean oldValue, boolean newValue) {
        this.checkAspectName(propertyName);
        super.firePropertyChanged(propertyName, oldValue, newValue);
    }

    public void fireItemsAdded(CollectionChangeEvent event) {
        this.checkAspectName(event.getCollectionName());
        super.fireItemsAdded(event);
    }

    public void fireItemsAdded(String collectionName, Collection addedItems) {
        this.checkAspectName(collectionName);
        super.fireItemsAdded(collectionName, addedItems);
    }

    public void fireItemAdded(String collectionName, Object addedItem) {
        this.checkAspectName(collectionName);
        super.fireItemAdded(collectionName, addedItem);
    }

    public void fireItemsRemoved(CollectionChangeEvent event) {
        this.checkAspectName(event.getCollectionName());
        super.fireItemsRemoved(event);
    }

    public void fireItemsRemoved(String collectionName, Collection removedItems) {
        this.checkAspectName(collectionName);
        super.fireItemsRemoved(collectionName, removedItems);
    }

    public void fireItemRemoved(String collectionName, Object removedItem) {
        this.checkAspectName(collectionName);
        super.fireItemRemoved(collectionName, removedItem);
    }

    public void fireCollectionChanged(CollectionChangeEvent event) {
        this.checkAspectName(event.getCollectionName());
        super.fireCollectionChanged(event);
    }

    public void fireCollectionChanged(String collectionName) {
        this.checkAspectName(collectionName);
        super.fireCollectionChanged(collectionName);
    }

    public void fireItemsAdded(ListChangeEvent event) {
        this.checkAspectName(event.getListName());
        super.fireItemsAdded(event);
    }

    public void fireItemsAdded(String listName, int index, List addedItems) {
        this.checkAspectName(listName);
        super.fireItemsAdded(listName, index, addedItems);
    }

    public void fireItemAdded(String listName, int index, Object addedItem) {
        this.checkAspectName(listName);
        super.fireItemAdded(listName, index, addedItem);
    }

    public void fireItemsRemoved(ListChangeEvent event) {
        this.checkAspectName(event.getListName());
        super.fireItemsRemoved(event);
    }

    public void fireItemsRemoved(String listName, int index, List removedItems) {
        this.checkAspectName(listName);
        super.fireItemsRemoved(listName, index, removedItems);
    }

    public void fireItemRemoved(String listName, int index, Object removedItem) {
        this.checkAspectName(listName);
        super.fireItemRemoved(listName, index, removedItem);
    }

    public void fireItemsReplaced(ListChangeEvent event) {
        this.checkAspectName(event.getListName());
        super.fireItemsReplaced(event);
    }

    public void fireItemsReplaced(String listName, int index, List newItems, List replacedItems) {
        this.checkAspectName(listName);
        super.fireItemsReplaced(listName, index, newItems, replacedItems);
    }

    public void fireItemReplaced(String listName, int index, Object newItem, Object replacedItem) {
        this.checkAspectName(listName);
        super.fireItemReplaced(listName, index, newItem, replacedItem);
    }

    public void fireListChanged(ListChangeEvent event) {
        this.checkAspectName(event.getListName());
        super.fireListChanged(event);
    }

    public void fireListChanged(String listName) {
        this.checkAspectName(listName);
        super.fireListChanged(listName);
    }

    public void fireNodeAdded(TreeChangeEvent event) {
        this.checkAspectName(event.getTreeName());
        super.fireNodeAdded(event);
    }

    public void fireNodeAdded(String treeName, Object[] path) {
        this.checkAspectName(treeName);
        super.fireNodeAdded(treeName, path);
    }

    public void fireNodeRemoved(TreeChangeEvent event) {
        this.checkAspectName(event.getTreeName());
        super.fireNodeRemoved(event);
    }

    public void fireNodeRemoved(String treeName, Object[] path) {
        this.checkAspectName(treeName);
        super.fireNodeRemoved(treeName, path);
    }

    public void fireTreeChanged(TreeChangeEvent event) {
        this.checkAspectName(event.getTreeName());
        super.fireTreeChanged(event);
    }

    public void fireTreeChanged(String treeName, Object[] path) {
        this.checkAspectName(treeName);
        super.fireTreeChanged(treeName, path);
    }
}

