/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemAspectListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;

public class ItemPropertyListValueModelAdapter
extends ItemAspectListValueModelAdapter {
    protected final String[] propertyNames;
    protected PropertyChangeListener itemPropertyListener;

    public ItemPropertyListValueModelAdapter(ListValueModel listHolder, String propertyName) {
        this(listHolder, new String[]{propertyName});
    }

    public ItemPropertyListValueModelAdapter(ListValueModel listHolder, String propertyName1, String propertyName2) {
        this(listHolder, new String[]{propertyName1, propertyName2});
    }

    public ItemPropertyListValueModelAdapter(ListValueModel listHolder, String propertyName1, String propertyName2, String propertyName3) {
        this(listHolder, new String[]{propertyName1, propertyName2, propertyName3});
    }

    public ItemPropertyListValueModelAdapter(ListValueModel listHolder, String[] propertyNames) {
        super(listHolder);
        this.propertyNames = propertyNames;
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel collectionHolder, String propertyName) {
        this(collectionHolder, new String[]{propertyName});
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel collectionHolder, String propertyName1, String propertyName2) {
        this(collectionHolder, new String[]{propertyName1, propertyName2});
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel collectionHolder, String propertyName1, String propertyName2, String propertyName3) {
        this(collectionHolder, new String[]{propertyName1, propertyName2, propertyName3});
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel collectionHolder, String[] propertyNames) {
        super(collectionHolder);
        this.propertyNames = propertyNames;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.itemPropertyListener = this.buildItemPropertyListener();
    }

    protected PropertyChangeListener buildItemPropertyListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ItemPropertyListValueModelAdapter.this.itemAspectChanged(e);
            }

            public String toString() {
                return "item property listener: " + Arrays.asList(ItemPropertyListValueModelAdapter.this.propertyNames);
            }
        };
    }

    @Override
    protected void startListeningToItem(Model item) {
        int i = this.propertyNames.length;
        while (i-- > 0) {
            item.addPropertyChangeListener(this.propertyNames[i], this.itemPropertyListener);
        }
    }

    @Override
    protected void stopListeningToItem(Model item) {
        int i = this.propertyNames.length;
        while (i-- > 0) {
            item.removePropertyChangeListener(this.propertyNames[i], this.itemPropertyListener);
        }
    }
}

