/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.login;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.SequenceType;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DefaultSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NativeSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TableSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.UnaryTableSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.AbstractLoginPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.DefaultSequencePropertyPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.NativeSequencePropertyPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.NewSequenceDialog;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.TableSequencePropertyPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.UnaryTableSequencePropertyPane;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CompositeCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.NullTransformer;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class SequencingPropertiesPage
extends AbstractLoginPropertiesPage {
    private DefaultSequencePropertyPane defaultSequencePane;
    private NativeSequencePropertyPane nativeSequencePane;
    private TableSequencePropertyPane tableSequencePane;
    private UnaryTableSequencePropertyPane unaryTableSequencePane;
    public static String CUSTOM_TABLE_SEQUENCE = "CustomTableSequence";
    public static String DEFAULT_TABLE_SEQUENCE = "DefaultTableSequence";
    public static String NATIVE_TABLE_SEQUENCE = "NativeTableSequence";

    public SequencingPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    @Override
    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel container = new JPanel(new GridBagLayout());
        container.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        AddRemoveListPanel listPane = this.buildSequenceListPane();
        PropertyValueModel selectedSequenceHolder = listPane.getSelectedItemHolder();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 3;
        constraints.anchor = 10;
        constraints.insets = new Insets(15, 0, 0, 0);
        container.add((Component)listPane, constraints);
        this.defaultSequencePane = this.buildDefaultSequencePane(selectedSequenceHolder);
        this.nativeSequencePane = this.buildNativeSequencePane(selectedSequenceHolder);
        this.tableSequencePane = this.buildTableSequencePane(selectedSequenceHolder);
        this.unaryTableSequencePane = this.buildUnaryTableSequencePane(selectedSequenceHolder);
        SwitcherPanel sequencePane = new SwitcherPanel(selectedSequenceHolder, this.buildSequencePaneTransformer());
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(15, 10, 0, 0);
        container.add((Component)sequencePane, constraints);
        this.addHelpTopicId(container, "session.login.sequencing");
        return container;
    }

    private Transformer buildSequencePaneTransformer() {
        return new Transformer(){

            public Component transform(Object sequence) {
                if (sequence == null) {
                    return null;
                }
                if (((SequenceAdapter)sequence).getType() == SequenceType.DEFAULT) {
                    return SequencingPropertiesPage.this.defaultSequencePane;
                }
                if (((SequenceAdapter)sequence).getType() == SequenceType.NATIVE) {
                    return SequencingPropertiesPage.this.nativeSequencePane;
                }
                if (((SequenceAdapter)sequence).getType() == SequenceType.TABLE) {
                    return SequencingPropertiesPage.this.tableSequencePane;
                }
                if (((SequenceAdapter)sequence).getType() == SequenceType.UNARY_TABLE) {
                    return SequencingPropertiesPage.this.unaryTableSequencePane;
                }
                return null;
            }
        };
    }

    private ValueModel buildTableSequenceHolder(ValueModel selectedSequenceHolder) {
        return new TransformationValueModel(selectedSequenceHolder){

            @Override
            protected TableSequenceAdapter transformNonNull(Object value) {
                return ((SequenceAdapter)value).getType() == SequenceType.TABLE ? (TableSequenceAdapter)value : null;
            }
        };
    }

    private TableSequencePropertyPane buildTableSequencePane(ValueModel selectedSequenceHolder) {
        return new TableSequencePropertyPane(this.buildTableSequenceHolder(selectedSequenceHolder), this.getWorkbenchContextHolder());
    }

    private ValueModel buildUnaryTableSequenceHolder(ValueModel selectedSequenceHolder) {
        return new TransformationValueModel(selectedSequenceHolder){

            @Override
            protected UnaryTableSequenceAdapter transformNonNull(Object value) {
                return ((SequenceAdapter)value).getType() == SequenceType.UNARY_TABLE ? (UnaryTableSequenceAdapter)value : null;
            }
        };
    }

    private UnaryTableSequencePropertyPane buildUnaryTableSequencePane(ValueModel selectedSequenceHolder) {
        return new UnaryTableSequencePropertyPane(this.buildUnaryTableSequenceHolder(selectedSequenceHolder), this.getWorkbenchContextHolder());
    }

    private ValueModel buildNativeSequenceHolder(ValueModel selectedSequenceHolder) {
        return new TransformationValueModel(selectedSequenceHolder){

            @Override
            protected NativeSequenceAdapter transformNonNull(Object value) {
                return ((SequenceAdapter)value).getType() == SequenceType.NATIVE ? (NativeSequenceAdapter)value : null;
            }
        };
    }

    private NativeSequencePropertyPane buildNativeSequencePane(ValueModel selectedSequenceHolder) {
        return new NativeSequencePropertyPane(this.buildNativeSequenceHolder(selectedSequenceHolder), this.getWorkbenchContextHolder());
    }

    private ValueModel buildDefaultSequenceHolder(ValueModel selectedSequenceHolder) {
        return new TransformationValueModel(selectedSequenceHolder){

            @Override
            protected DefaultSequenceAdapter transformNonNull(Object value) {
                return ((SequenceAdapter)value).getType() == SequenceType.DEFAULT ? (DefaultSequenceAdapter)value : null;
            }
        };
    }

    private DefaultSequencePropertyPane buildDefaultSequencePane(ValueModel selectedSequenceHolder) {
        return new DefaultSequencePropertyPane(this.buildDefaultSequenceHolder(selectedSequenceHolder), this.getWorkbenchContextHolder());
    }

    private AddRemoveListPanel buildSequenceListPane() {
        AddRemoveListPanel panel = new AddRemoveListPanel(this.getApplicationContext(), this.buildSequenceListAdapter(), this.buildSortedSequenceListHolder()){

            @Override
            protected void updateRemoveButton(JButton removeButton) {
                SequenceAdapter sequence = (SequenceAdapter)this.getSelectionModel().getSelectedValue();
                removeButton.setEnabled(sequence != null && this.getSelectedValues().length == 1 && !sequence.isTheDefaultSequence());
            }
        };
        panel.setCellRenderer(this.buildSequenceListRenderer());
        return panel;
    }

    private ListCellRenderer buildSequenceListRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                boolean hasName;
                SequenceAdapter sequence = (SequenceAdapter)value;
                StringBuilder sb = new StringBuilder();
                boolean bl = hasName = !StringTools.stringIsEmpty((String)sequence.getName());
                if (hasName) {
                    sb.append(sequence.getName());
                } else if (!sequence.isTheDefaultSequence()) {
                    sb.append(SequencingPropertiesPage.this.resourceRepository().getString("SEQUENCING_PANE_SEQUENCE_NO_NAME", index));
                } else {
                    sb.append(SequencingPropertiesPage.this.resourceRepository().getString("SEQUENCING_PANE_DEFAULT_SEQUENCE_TEXT"));
                }
                StringBuilder sequenceType = new StringBuilder();
                sequenceType.append("SEQUENCING_PANE_SEQUENCE_TYPE_");
                sequenceType.append(sequence.getType().name());
                sb.append(' ');
                sb.append('(');
                sb.append(SequencingPropertiesPage.this.resourceRepository().getString(sequenceType.toString()));
                sb.append(')');
                if (hasName && sequence.isTheDefaultSequence()) {
                    sb.append(' ');
                    sb.append(SequencingPropertiesPage.this.resourceRepository().getString("SEQUENCING_PANE_DEFAULT_SEQUENCE_TEXT"));
                }
                return sb.toString();
            }
        };
    }

    private CollectionValueModel buildAllSequenceCollectionHolder() {
        SimpleCollectionValueModel collectionHolders = new SimpleCollectionValueModel();
        collectionHolders.addItem(this.buildSequenceCollectionHolder());
        collectionHolders.addItem(this.buildDefaultSequenceCollectionHolder());
        return new CompositeCollectionValueModel(collectionHolders, NullTransformer.instance());
    }

    private CollectionValueModel buildDefaultSequenceCollectionHolder() {
        return new PropertyCollectionValueModelAdapter(this.buildDefaultCollectionHolder());
    }

    private PropertyValueModel buildDefaultCollectionHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "defaultSequence"){

            @Override
            protected SequenceAdapter getValueFromSubject() {
                return ((LoginAdapter)this.subject).getDefaultSequence();
            }
        };
    }

    private CollectionValueModel buildSequenceCollectionHolder() {
        return new ListCollectionValueModelAdapter(this.buildSequenceListHolder());
    }

    private ListValueModel buildSequenceListHolder() {
        return new ListAspectAdapter(this.getSelectionHolder(), "sequences"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((LoginAdapter)this.subject).sequences();
            }

            @Override
            protected int sizeFromSubject() {
                return ((LoginAdapter)this.subject).sequencesSize();
            }
        };
    }

    private ListValueModel buildSortedSequenceListHolder() {
        return new SortedListValueModelAdapter(this.buildAllSequenceCollectionHolder());
    }

    private LoginAdapter login() {
        return (LoginAdapter)this.selection();
    }

    private void editSequence(ObjectListSelectionModel listSelectionModel) {
        SequenceAdapter sequence = (SequenceAdapter)listSelectionModel.getSelectedValue();
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setTextFieldDescription(this.resourceRepository().getString("SEQUENCING_PANE_EDIT_SEQUENCE_DIALOG_LABEL"));
        builder.setTitle(this.resourceRepository().getString("SEQUENCING_PANE_EDIT_SEQUENCE_DIALOG_TITLE"));
        builder.setHelpTopicId("dialog.sequence");
        builder.setExistingNames(this.login().sequenceNames());
        builder.setOriginalName(sequence.getName());
        builder.setOriginalNameIsLegal(false);
        builder.setEmptyNameIsLegal(sequence.isDefault());
        NewNameDialog dialog = builder.buildDialog(this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasConfirmed()) {
            String name = dialog.getNewName().trim();
            sequence.setName(name);
            listSelectionModel.setSelectedValue(sequence);
        }
    }

    private void addSequence(ObjectListSelectionModel listSelectionModel) {
        NewSequenceDialog.NewSequenceBuilder builder = new NewSequenceDialog.NewSequenceBuilder(this.resourceRepository());
        builder.addExistingNames(this.login().sequenceNames());
        NewSequenceDialog dialog = builder.buildDialog(this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasConfirmed()) {
            NewSequenceDialog.SequenceStateObject stateObject = (NewSequenceDialog.SequenceStateObject)dialog.subject();
            SequenceAdapter sequence = stateObject.isDefaultSequence() ? this.login().createAndSetDefaultSequence(stateObject.getName(), stateObject.getSequenceType()) : this.login().addSequence(stateObject.getName(), stateObject.getSequenceType());
            listSelectionModel.setSelectedValue(sequence);
        }
    }

    private AddRemovePanel.Adapter buildSequenceListAdapter() {
        return new AddRemovePanel.OptionAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                SequencingPropertiesPage.this.addSequence(listSelectionModel);
            }

            @Override
            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                return listSelectionModel.getSelectedValuesSize() == 1;
            }

            @Override
            public String optionalButtonKey() {
                return "SEQUENCING_PANE_EDIT_BUTTON";
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                SequencingPropertiesPage.this.editSequence(listSelectionModel);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                for (Object sequence : listSelectionModel.getSelectedValues()) {
                    SequencingPropertiesPage.this.login().removeSequence((SequenceAdapter)sequence);
                }
            }
        };
    }
}

