/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.login;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.framework.uitools.TriStateBooleanCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.AbstractLoginPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.StructConvertersPane;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

public class RdbmsOptionsPropertiesPage
extends AbstractLoginPropertiesPage {
    public RdbmsOptionsPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    private JComponent buildAdvancedOptionsPane() {
        GridBagConstraints constraints = new GridBagConstraints();
        int index = 0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        JPanel panel = new JPanel(new GridBagLayout());
        JCheckBox forceFieldNamesToUpperCaseCheckBox = this.buildCheckBox("LOGIN_FORCE_FIELD_NAMES_TO_UPPERCASE_CHECK_BOX", this.buildForceFieldNamesToUppercaseCheckBoxAdapter());
        constraints.gridy = index++;
        panel.add((Component)forceFieldNamesToUpperCaseCheckBox, constraints);
        JCheckBox optimizeDataConversionCheckBox = this.buildCheckBox("LOGIN_OPTIMIZE_DATA_CONVERSION_CHECK_BOX", this.buildOptimizeDataConversionCheckBoxAdapter());
        constraints.gridy = index++;
        panel.add((Component)optimizeDataConversionCheckBox, constraints);
        JCheckBox trimStringCheckBox = this.buildCheckBox("LOGIN_TRIM_STRING_CHECK_BOX", this.buildTrimStringsCheckBoxAdapter());
        constraints.gridy = index++;
        panel.add((Component)trimStringCheckBox, constraints);
        JCheckBox propertiesCheckBox = this.buildCheckBox("LOGIN_USE_PROPERTIES_CHECK_BOX", this.buildUsePropertiesCheckBoxAdapter());
        constraints.gridy = index++;
        constraints.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)propertiesCheckBox, constraints);
        this.addHelpTopicId(panel, "session.login.database.options.advanced");
        return panel;
    }

    private CollectionValueModel buildBatchWritingCollectionHolder() {
        Vector<TriStateBoolean> booleanValues = new Vector<TriStateBoolean>();
        booleanValues.add(TriStateBoolean.UNDEFINED);
        booleanValues.add(TriStateBoolean.TRUE);
        booleanValues.add(TriStateBoolean.FALSE);
        return new ReadOnlyCollectionValueModel(booleanValues);
    }

    private ComboBoxModel buildBatchWritingComboBoxAdapter() {
        return new ComboBoxModelAdapter(this.buildBatchWritingCollectionHolder(), this.buildBatchWritingSelectionHolder());
    }

    private CellRendererAdapter buildBatchWritingLabelDecorator() {
        return new TriStateBooleanCellRendererAdapter(this.resourceRepository()){

            @Override
            protected String undefinedResourceKey() {
                return "LOGIN_BATCH_WRITING_NONE_CHOICE";
            }

            @Override
            protected String trueResourceKey() {
                return "LOGIN_BATCH_WRITING_JDBC_CHOICE";
            }

            @Override
            protected String falseResourceKey() {
                return "LOGIN_BATCH_WRITING_BUFFERED_CHOICE";
            }
        };
    }

    private PropertyValueModel buildBatchWritingSelectionHolder() {
        String[] propertyNames = new String[]{"batchWriting", "jdbcBatchWriting"};
        return new PropertyAspectAdapter(this.getSelectionHolder(), propertyNames){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                boolean batchWriting = login.usesBatchWriting();
                if (!batchWriting) {
                    return TriStateBoolean.UNDEFINED;
                }
                return TriStateBoolean.valueOf((boolean)login.usesJdbcBatchWriting());
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                TriStateBoolean batchWriting = (TriStateBoolean)value;
                login.setBatchWriting(!batchWriting.isUndefined());
                if (batchWriting.isTrue()) {
                    login.setJdbcBatchWriting(true);
                } else if (batchWriting.isFalse()) {
                    login.setJdbcBatchWriting(false);
                }
            }
        };
    }

    private JComponent buildBatchWritingStringBindingPane() {
        GridBagConstraints constraints = new GridBagConstraints();
        int space = SwingTools.checkBoxIconWidth();
        JPanel container = new JPanel(new GridBagLayout());
        container.getAccessibleContext().setAccessibleName(this.resourceRepository().getString("LOGIN_JDBC_OPTIONS_TITLE"));
        JLabel batchWritingLabel = this.buildLabel("LOGIN_BATCH_WRITING_COMBO_BOX");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(2, space, 0, 0);
        container.add((Component)batchWritingLabel, constraints);
        JComboBox<Object> batchWritingComboBox = new JComboBox<Object>(this.buildBatchWritingComboBoxAdapter());
        batchWritingComboBox.setRenderer(new AdaptableListCellRenderer(this.buildBatchWritingLabelDecorator()));
        batchWritingComboBox.setName("LOGIN_BATCH_WRITING_COMBO_BOX");
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(2, 20, 0, 0);
        container.add(batchWritingComboBox, constraints);
        batchWritingLabel.setLabelFor(batchWritingComboBox);
        JLabel stringSizeLabel = this.buildLabel("LOGIN_MAX_BATCH_WRITING_SIZE_SPINNER");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 25;
        constraints.insets = new Insets(2, 40, 0, 0);
        container.add((Component)stringSizeLabel, constraints);
        JSpinner stringSizeSpinner = SwingComponentFactory.buildSpinnerNumber(this.buildStringSizeSpinnerAdapter());
        stringSizeSpinner.setName("LOGIN_MAX_BATCH_WRITING_SIZE_SPINNER");
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(2, 5, 0, 0);
        container.add((Component)stringSizeSpinner, constraints);
        stringSizeLabel.setLabelFor(stringSizeSpinner);
        JCheckBox stringBindingCheckBox = this.buildCheckBox("LOGIN_STRING_BINDING_CHECK_BOX", this.buildStringBindingCheckBoxAdapter());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(4, 0, 0, 0);
        container.add((Component)stringBindingCheckBox, constraints);
        return container;
    }

    private ButtonModel buildByteArrayBindingCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildByteArrayBindingHolder());
    }

    private PropertyValueModel buildByteArrayBindingHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "byteArrayBinding"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                return login.usesByteArrayBinding();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                login.setByteArrayBinding(Boolean.TRUE.equals(value));
            }
        };
    }

    private ButtonModel buildCacheAllStatementsCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildCacheAllStatementsHolder());
    }

    private PropertyValueModel buildCacheAllStatementsHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "cacheAllStatements"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                return login.cachesAllStatements();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                login.setCacheAllStatements(Boolean.TRUE.equals(value));
            }
        };
    }

    private ButtonModel buildConnectionHealthValidatedOnErrorCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildConnectionHealthValidatedOnErrorHolder());
    }

    private PropertyValueModel buildConnectionHealthValidatedOnErrorHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "connectionHealthValidateOnError"){

            @Override
            protected Object getValueFromSubject() {
                return ((DatabaseLoginAdapter)this.subject).isConnectionHealthValidatedOnError();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((DatabaseLoginAdapter)this.subject).setConnectionHealthValidatedOnError((Boolean)value);
            }
        };
    }

    private ButtonModel buildNativeSequencingCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildNativeSequencingHolder());
    }

    private PropertyValueModel buildNativeSequencingHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "nativeSequencing"){

            @Override
            protected Object getValueFromSubject() {
                return ((DatabaseLoginAdapter)this.subject).isNativeSequencing();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((DatabaseLoginAdapter)this.subject).setIsNativeSequencing((Boolean)value);
            }
        };
    }

    private ButtonModel buildForceFieldNamesToUppercaseCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildForceFieldNamesToUppercaseHolder());
    }

    private PropertyValueModel buildForceFieldNamesToUppercaseHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "forceFieldNamesToUppercase"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                return login.forcesFieldNamesToUppercase();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                login.setForceFieldNamesToUppercase(Boolean.TRUE.equals(value));
            }
        };
    }

    private JComponent buildJDBCOptionsPane() {
        GridBagConstraints constraints = new GridBagConstraints();
        int index = 0;
        int space = SwingTools.checkBoxIconWidth() + 5;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, space, 0, 0);
        JPanel panel = new JPanel(new GridBagLayout());
        JComponent pingSQLWidgets = this.buildLabeledTextField("JDBC_OPTIONS_PANE_PING_SQL_LABEL", this.buildPingSQLDocument());
        constraints.fill = 2;
        constraints.gridy = index++;
        panel.add((Component)pingSQLWidgets, constraints);
        JComponent queryRetryAttemptsWidgets = this.buildLabeledSpinnerNumber("JDBC_OPTIONS_PANE_QUERY_RETRY_ATTEMPTS_LABEL", this.buildQueryRetryAttemptsSpinnerModel(), 6);
        constraints.gridy = index++;
        constraints.insets = new Insets(5, space, 0, 0);
        panel.add((Component)queryRetryAttemptsWidgets, constraints);
        JComponent delayBetweenConnectionAttemptsWidgets = this.buildLabeledSpinnerNumber("JDBC_OPTIONS_PANE_DELAY_BETWEEN_CONNECTION_ATTEMPTS_LABEL", this.buildDelayBetweenConnectionAttemptsSpinnerModel(), 6);
        constraints.gridy = index++;
        panel.add((Component)delayBetweenConnectionAttemptsWidgets, constraints);
        JCheckBox connectionHealthValidatedOnErrorCheckBox = this.buildCheckBox("JDBC_OPTIONS_PANE_CONNECTION_HEALTH_VALIDATED_ON_ERROR_CHECK_BOX", this.buildConnectionHealthValidatedOnErrorCheckBoxModel());
        constraints.fill = 0;
        constraints.gridy = index++;
        constraints.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)connectionHealthValidatedOnErrorCheckBox, constraints);
        JCheckBox queriesShouldBindAllParametersCheckBox = this.buildCheckBox("LOGIN_QUERIES_SHOULD_BIND_ALL_PARAMETERS_CHECK_BOX", this.buildQueriesShouldBindAllParametersCheckBoxAdapter());
        constraints.gridy = index++;
        panel.add((Component)queriesShouldBindAllParametersCheckBox, constraints);
        JCheckBox cacheAllStatementsCheckBox = this.buildCheckBox("LOGIN_CACHE_ALL_STATEMENTS_CHECK_BOX", this.buildCacheAllStatementsCheckBoxAdapter());
        constraints.gridy = index++;
        panel.add((Component)cacheAllStatementsCheckBox, constraints);
        JCheckBox byteArrayBindingCheckBox = this.buildCheckBox("LOGIN_BYTE_ARRAY_BINDING_CHECK_BOX", this.buildByteArrayBindingCheckBoxAdapter());
        constraints.gridy = index++;
        panel.add((Component)byteArrayBindingCheckBox, constraints);
        JCheckBox streamsForBindingCheckBox = this.buildCheckBox("LOGIN_STREAMS_FOR_BINDING_CHECK_BOX", this.buildStreamsForBindingCheckBoxAdapter());
        constraints.gridy = index++;
        panel.add((Component)streamsForBindingCheckBox, constraints);
        JCheckBox nativeSequencingCheckBox = this.buildCheckBox("JDBC_OPTIONS_PANE_NATIVE_SEQUENCING_CHECK_BOX", this.buildNativeSequencingCheckBoxModel());
        constraints.gridy = index++;
        panel.add((Component)nativeSequencingCheckBox, constraints);
        JCheckBox nativeSQLCheckBox = this.buildCheckBox("LOGIN_NATIVE_SQL_CHECK_BOX", this.buildNativeSQLCheckBoxAdapter());
        constraints.gridy = index++;
        panel.add((Component)nativeSQLCheckBox, constraints);
        JComponent stringBindingPane = this.buildBatchWritingStringBindingPane();
        constraints.gridy = index++;
        constraints.insets = new Insets(0, 5, 5, 0);
        panel.add((Component)stringBindingPane, constraints);
        this.addHelpTopicId(panel, "session.login.database.options.jdbcOptions");
        return panel;
    }

    private SpinnerNumberModel buildQueryRetryAttemptsSpinnerModel() {
        return new NumberSpinnerModelAdapter(this.buildQueryRetryAttemptsHolder(), 0, Integer.MAX_VALUE, 1, 3);
    }

    private PropertyValueModel buildQueryRetryAttemptsHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "queryRetryAttemptCount"){

            @Override
            protected Object getValueFromSubject() {
                return ((DatabaseLoginAdapter)this.subject).getQueryRetryAttemptCount();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((DatabaseLoginAdapter)this.subject).setQueryRetryAttemptCount((Integer)value);
            }
        };
    }

    private SpinnerNumberModel buildDelayBetweenConnectionAttemptsSpinnerModel() {
        return new NumberSpinnerModelAdapter(this.buildDelayBetweenConnectionAttemptsHolder(), 0, Integer.MAX_VALUE, 1, 5000);
    }

    private PropertyValueModel buildDelayBetweenConnectionAttemptsHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "delayBetweenConnectionAttempts"){

            @Override
            protected Object getValueFromSubject() {
                return ((DatabaseLoginAdapter)this.subject).getDelayBetweenConnectionAttempts();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((DatabaseLoginAdapter)this.subject).setDelayBetweenConnectionAttempts((Integer)value);
            }
        };
    }

    private Document buildPingSQLDocument() {
        return new DocumentAdapter(this.buildPingSQLHolder());
    }

    private PropertyValueModel buildPingSQLHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "pingSQL"){

            @Override
            protected Object getValueFromSubject() {
                return ((DatabaseLoginAdapter)this.subject).getPingSQL();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((DatabaseLoginAdapter)this.subject).setPingSQL((String)value);
            }
        };
    }

    private ButtonModel buildNativeSQLCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildNativeSQLHolder());
    }

    private PropertyValueModel buildNativeSQLHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "nativeSQL"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                return login.usesNativeSQL();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                login.setNativeSQL(Boolean.TRUE.equals(value));
            }
        };
    }

    private ButtonModel buildOptimizeDataConversionCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildOptimizeDataConversionHolder());
    }

    private PropertyValueModel buildOptimizeDataConversionHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "optimizeDataConversion"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                return login.optimizesDataConversion();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                login.setOptimizeDataConversion(Boolean.TRUE.equals(value));
            }
        };
    }

    @Override
    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JComponent tableQualifierWidgets = this.buildLabeledTextField("LOGIN_TABLE_QUALIFIER_FIELD", this.buildTableQualifierDocumentAdater());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)tableQualifierWidgets, constraints);
        this.addHelpTopicId(tableQualifierWidgets, "session.login.database.options.tableQualifier");
        JComponent jdbcOptionsPanel = this.buildJDBCOptionsPane();
        jdbcOptionsPanel.setBorder(this.buildTitledBorder("LOGIN_JDBC_OPTIONS_TITLE"));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)jdbcOptionsPanel, constraints);
        JComponent advancedOptionsPanel = this.buildAdvancedOptionsPane();
        advancedOptionsPanel.setBorder(this.buildTitledBorder("LOGIN_ADVANCED_OPTIONS_TITLE"));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)advancedOptionsPanel, constraints);
        StructConvertersPane structConvertersPane = new StructConvertersPane(this.getSelectionHolder(), this.getWorkbenchContextHolder());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)structConvertersPane, constraints);
        this.addPaneForAlignment(structConvertersPane);
        this.addHelpTopicId(panel, "session.login.database.options");
        return panel;
    }

    private ButtonModel buildQueriesShouldBindAllParametersCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildQueriesShouldBindAllParametersHolder());
    }

    private PropertyValueModel buildQueriesShouldBindAllParametersHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "bindAllParameters"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                return login.bindsAllParameters();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                login.setBindAllParameters(Boolean.TRUE.equals(value));
            }
        };
    }

    private ButtonModel buildStreamsForBindingCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildStreamsForBindingHolder());
    }

    private PropertyValueModel buildStreamsForBindingHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "streamsForBinding"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                return login.usesStreamsForBinding();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                login.setStreamsForBinding(Boolean.TRUE.equals(value));
            }
        };
    }

    private ButtonModel buildStringBindingCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildStringBindingHolder());
    }

    private PropertyValueModel buildStringBindingHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "stringBinding"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                return login.usesStringBinding();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                login.setStringBinding(Boolean.TRUE.equals(value));
            }
        };
    }

    private PropertyValueModel buildStringSizeHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "maxBatchWritingSize"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                return new Integer(adapter.getMaxBatchWritingSize());
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                adapter.setMaxBatchWritingSize((Integer)value);
            }
        };
    }

    private SpinnerNumberModel buildStringSizeSpinnerAdapter() {
        return new NumberSpinnerModelAdapter(this.buildStringSizeHolder(), 0, Integer.MAX_VALUE, 1);
    }

    private Document buildTableQualifierDocumentAdater() {
        return new DocumentAdapter(this.buildTableQualifierHolder());
    }

    private PropertyValueModel buildTableQualifierHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "tableQualifier"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                return adapter.getTableQualifier();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                adapter.setTableQualifier((String)value);
            }
        };
    }

    private ButtonModel buildTrimStringsCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildTrimStringsHolder());
    }

    private PropertyValueModel buildTrimStringsHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "trimStrings"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                return login.trimsStrings();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                login.setTrimStrings(Boolean.TRUE.equals(value));
            }
        };
    }

    private ButtonModel buildUsePropertiesCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildUsePropertiesHolder());
    }

    private PropertyValueModel buildUsePropertiesHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "useProperties"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                return login.usesProperties();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                login.setUseProperties(Boolean.TRUE.equals(value));
            }
        };
    }
}

