/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentDetail;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentQNamedDetail;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementListIterator;

abstract class NamedSchemaComponentNodeStructure
extends SchemaComponentNodeStructure {
    private String qName;
    private PropertyChangeListener qNameListener;

    NamedSchemaComponentNodeStructure(MWNamedSchemaComponent component) {
        super((MWSchemaComponent)component);
        this.initialize(component);
    }

    private void initialize(MWNamedSchemaComponent component) {
        this.qName = component.qName();
        this.qNameListener = this.buildQNameListener();
        component.getTargetNamespace().addPropertyChangeListener("namespacePrefix", this.qNameListener);
    }

    private PropertyChangeListener buildQNameListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NamedSchemaComponentNodeStructure.this.qNameChanged();
            }
        };
    }

    @Override
    void disengageComponent() {
        ((MWNamedSchemaComponent)this.getComponent()).getTargetNamespace().removePropertyChangeListener("namespacePrefix", this.qNameListener);
        super.disengageComponent();
    }

    private void qNameChanged() {
        String oldQName = this.qName;
        if (this.getComponent() != null) {
            this.qName = ((MWNamedSchemaComponent)this.getComponent()).qName();
            this.firePropertyChanged("displayString", oldQName, this.qName);
        }
    }

    protected ListIterator nameDetails() {
        return new SingleElementListIterator((Object)this.buildNameDetail());
    }

    SchemaComponentDetail buildNameDetail() {
        return new SchemaComponentQNamedDetail(this.getComponent()){

            @Override
            protected String getName() {
                return "name";
            }

            @Override
            protected MWNamedSchemaComponent getQNamedComponent() {
                return (MWNamedSchemaComponent)this.component;
            }
        };
    }

    abstract Integer topLevelOrderIndex();

    @Override
    public String displayString() {
        MWNamedSchemaComponent namedComponent = (MWNamedSchemaComponent)this.getComponent();
        String designator = namedComponent.isReference() ? "ref" : "name";
        return namedComponent.componentTypeName() + ": " + designator + "=\"" + namedComponent.qName() + "\"";
    }
}

