/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractToggleFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.MappingNode;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class ChangeMappingTypeAction
extends AbstractToggleFrameworkAction {
    protected ChangeMappingTypeAction(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected void engageValueEnabled(AbstractApplicationNode node) {
        super.engageValueEnabled(node);
        ((MappingNode)node).descriptor().addPropertyChangeListener("active", this.getEnabledStateListener());
    }

    @Override
    protected void disengageValueEnabled(AbstractApplicationNode node) {
        super.disengageValueEnabled(node);
        ((MappingNode)node).descriptor().removePropertyChangeListener("active", this.getEnabledStateListener());
    }

    @Override
    protected void execute() {
        ApplicationNode[] nodes = this.selectedNodes();
        TreePath[] selectionPaths = new TreePath[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            ApplicationNode node = nodes[i];
            node = this.morphNode((MappingNode)node);
            selectionPaths[i] = new TreePath(node.path());
        }
        this.navigatorSelectionModel().setSelectionPaths(selectionPaths);
    }

    protected MappingNode morphNode(MappingNode mappingNode) {
        MWMapping mapping = mappingNode.isMapped() ? this.morphMapping(mappingNode.getMapping()) : this.addMapping(mappingNode.descriptor(), mappingNode.instanceVariable());
        return (MappingNode)mappingNode.getDescriptorNode().descendantNodeForValue((Node)mapping);
    }

    protected abstract MWMapping morphMapping(MWMapping var1);

    protected abstract MWMapping addMapping(MWMappingDescriptor var1, MWClassAttribute var2);

    @Override
    protected boolean shouldBeSelected(ApplicationNode selectedNode) {
        return this.nodeIsMorphed((MappingNode)selectedNode);
    }

    @Override
    protected boolean shouldBeEnabled(ApplicationNode selectedNode) {
        return ((MappingNode)selectedNode).descriptor().isActive();
    }

    protected boolean nodeIsMorphed(MappingNode mappingNode) {
        return mappingNode.isMapped() && this.mappingClass().isAssignableFrom(mappingNode.getMapping().getClass());
    }

    protected abstract Class mappingClass();
}

