/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodParameter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ClassCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ZeroArgConstructorPreference;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SpinnerTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class MethodParametersPanel
extends AbstractPanel {
    private PropertyValueModel methodHolder;
    private ObjectListSelectionModel rowSelectionModel;
    private ListValueModel paramatersHolder;
    private JButton removeParameterButton;

    WorkbenchContext workbenchContext() {
        return this.getWorkbenchContext();
    }

    MethodParametersPanel(PropertyValueModel methodHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.methodHolder = methodHolder;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.paramatersHolder = this.buildParametersAdapter();
        this.rowSelectionModel = this.buildRowSelectionModel();
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel rowSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.paramatersHolder));
        rowSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        return rowSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    MethodParametersPanel.this.removeParameterButton.setEnabled(MethodParametersPanel.this.rowSelectionModel.getSelectedValue() != null);
                }
            }
        };
    }

    private ListValueModel buildParametersAdapter() {
        return new ListAspectAdapter(this.methodHolder, "methodParameters"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((MWMethod)this.subject).methodParameters();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWMethod)this.subject).methodParametersSize();
            }
        };
    }

    MWMethod getMethod() {
        return (MWMethod)this.methodHolder.getValue();
    }

    private MWClass getMWClass() {
        return (MWClass)this.getMethod().getMWParent();
    }

    private Iterator selectedParameters() {
        return CollectionTools.iterator((Object[])this.rowSelectionModel.getSelectedValues());
    }

    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        MethodParametersPanel mainPanel = this;
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        JButton addParameterButton = this.buildButton("ADD_PARAMETER");
        addParameterButton.addActionListener(new AddParameterAction());
        addParameterButton.setEnabled(false);
        this.methodHolder.addPropertyChangeListener("value", this.buildMethodListener(addParameterButton));
        buttonPanel.add(addParameterButton);
        this.removeParameterButton = this.buildButton("REMOVE_PARAMETER");
        this.removeParameterButton.addActionListener(new RemoveParameterAction());
        this.removeParameterButton.setEnabled(false);
        buttonPanel.add(this.removeParameterButton);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets = new Insets(5, 5, 0, 0);
        mainPanel.add((Component)buttonPanel, constraints);
        JTable table = this.buildParametersTable();
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.getViewport().setBackground(table.getBackground());
        scrollPane.getViewport().setPreferredSize(new Dimension(40, 30));
        table.addPropertyChangeListener("enabled", new PropertyChangeHandler(scrollPane));
        this.methodHolder.addPropertyChangeListener("value", this.buildMethodListener(table));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)scrollPane, constraints);
    }

    private JTable buildParametersTable() {
        JTable table = SwingComponentFactory.buildTable(this.buildParametersTableModel(), this.rowSelectionModel);
        int rowHeight = 20;
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setCellRenderer(this.buildTypeRenderer());
        column = table.getColumnModel().getColumn(1);
        SpinnerTableCellRenderer spinnerRenderer = this.buildNumberSpinnerRenderer();
        column.setCellRenderer(spinnerRenderer);
        column.setCellEditor(new TableCellEditorAdapter(this.buildNumberSpinnerRenderer()));
        rowHeight = Math.max(rowHeight, spinnerRenderer.getPreferredHeight());
        table.setRowHeight(rowHeight);
        return table;
    }

    private SpinnerTableCellRenderer buildNumberSpinnerRenderer() {
        return new SpinnerTableCellRenderer(new NumberSpinnerModelAdapter((PropertyValueModel)new SimplePropertyValueModel(), new Integer(0), null, new Integer(1), new Integer(0)));
    }

    private TableCellRenderer buildTypeRenderer() {
        return new AdaptableTableCellRenderer(new ClassCellRendererAdapter(this.resourceRepository()));
    }

    private TableModel buildParametersTableModel() {
        return new TableModelAdapter(this.paramatersHolder, this.buildParametersTableColumnAdapter());
    }

    private ColumnAdapter buildParametersTableColumnAdapter() {
        return new ParametersColumnAdapter(this.resourceRepository());
    }

    private void optionallyAddZeroArgumentConstructor() {
        ZeroArgConstructorPreference.optionallyAddZeroArgumentConstructor(this.getMWClass(), this.getWorkbenchContext());
    }

    protected void removeSelectedMethodParameters() {
        this.getMethod().removeMethodParameters(this.selectedParameters());
    }

    private PropertyChangeListener buildMethodListener(final Component component) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                component.setEnabled(MethodParametersPanel.this.getMethod() != null);
            }
        };
    }

    private static class ParametersColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int TYPE_COLUMN = 0;
        public static final int DIMENSIONALITY_COLUMN = 1;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"TYPE_COLUMN_HEADER", "DIMENSIONALITY_COLUMN_HEADER"};

        private ParametersColumnAdapter(ResourceRepository repository) {
            this.resourceRepository = repository;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int index) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[index]);
        }

        @Override
        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Integer.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isColumnEditable(int index) {
            return index != 0;
        }

        @Override
        public PropertyValueModel[] cellModels(Object subject) {
            MWMethodParameter methodParameter = (MWMethodParameter)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildTypeAdapter(methodParameter), this.buildDimensionalityAdapter(methodParameter)};
            return result;
        }

        private PropertyValueModel buildTypeAdapter(MWMethodParameter methodParameter) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter("type", (Model)methodParameter){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWMethodParameter)this.subject).getType();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWMethodParameter)this.subject).setType((MWClass)value);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "name");
        }

        private PropertyValueModel buildDimensionalityAdapter(MWMethodParameter methodParameter) {
            return new PropertyAspectAdapter("dimensionality", (Model)methodParameter){

                @Override
                protected Object getValueFromSubject() {
                    return new Integer(((MWMethodParameter)this.subject).getDimensionality());
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWMethodParameter)this.subject).setDimensionality(((Integer)value).intValue());
                }
            };
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private final JScrollPane scrollPane;

        private PropertyChangeHandler(JScrollPane scrollPane) {
            this.scrollPane = scrollPane;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JTable table = (JTable)this.scrollPane.getViewport().getView();
            if (table.isEnabled()) {
                this.scrollPane.getViewport().setBackground(table.getBackground());
            } else {
                this.scrollPane.getViewport().setBackground(UIManager.getColor("control"));
            }
        }
    }

    private class RemoveParameterAction
    implements ActionListener {
        private RemoveParameterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MethodParametersPanel.this.removeSelectedMethodParameters();
        }
    }

    private class AddParameterAction
    implements ActionListener {
        private AddParameterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MWClass type = ClassChooserTools.promptForType(MethodParametersPanel.this.getMethod().getRepository(), ClassChooserTools.buildDeclarableNonVoidFilter(), MethodParametersPanel.this.workbenchContext());
            if (type == null) {
                return;
            }
            if (MethodParametersPanel.this.getMethod().isZeroArgumentConstructor()) {
                MethodParametersPanel.this.getMethod().addMethodParameter(type);
                MethodParametersPanel.this.optionallyAddZeroArgumentConstructor();
            } else if (type.isVoid()) {
                JOptionPane.showMessageDialog(MethodParametersPanel.this.currentWindow(), MethodParametersPanel.this.resourceRepository().getString("METHOD_PARAMETER_TYPE_VOID_WARNING.message"), MethodParametersPanel.this.resourceRepository().getString("METHOD_PARAMETER_TYPE_VOID_WARNING.title"), 2);
            } else {
                MethodParametersPanel.this.getMethod().addMethodParameter(type);
            }
        }
    }
}

