/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.sql.SQLException;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.DatabaseNode;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class LogInAction
extends AbstractEnablableFrameworkAction {
    LogInAction(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeText("DATABASE_LOG_IN");
        this.initializeMnemonic("DATABASE_LOG_IN");
        this.initializeToolTipText("DATABASE_LOG_IN.toolTipText");
        this.initializeIcon("login");
    }

    @Override
    protected String[] enabledPropertyNames() {
        return new String[]{"connected"};
    }

    @Override
    protected boolean shouldBeEnabled(ApplicationNode selectedNode) {
        return !((MWDatabase)((DatabaseNode)selectedNode).getValue()).isConnected();
    }

    @Override
    protected void execute(ApplicationNode selectedNode) {
        MWDatabase database = (MWDatabase)selectedNode.getValue();
        if (!this.ableToLogin(database)) {
            return;
        }
        try {
            database.login();
        }
        catch (SQLException sqle) {
            String exceptionMessage = sqle.getMessage();
            StringBuffer dialogMessage = new StringBuffer(50);
            dialogMessage.append(exceptionMessage.substring(exceptionMessage.lastIndexOf(93) + 1));
            dialogMessage.append(StringTools.CR);
            dialogMessage.append(this.resourceRepository().getString("USER_NAME_OR_PASSWORD_COULD_BE_INVALID_MESSAGE"));
            JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), dialogMessage.toString(), this.resourceRepository().getString("ERROR_LOGGING_IN_TO_DATABASE.title"), 0);
        }
        catch (ClassNotFoundException cnfe) {
            String suggestion = this.resourceRepository().getString("JDBC_DRIVER_ON_CLASSPATH.message");
            JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("DATABASE_DRIVER_NOT_FOUND.message", new Object[]{cnfe.getMessage(), suggestion, StringTools.CR}), this.resourceRepository().getString("ERROR_LOGGING_IN_TO_DATABASE.title"), 0);
        }
    }

    private boolean ableToLogin(MWDatabase database) {
        MWLoginSpec login;
        if (database.isConnected()) {
            this.showErrorDialog(this.resourceRepository().getString("ALREADY_CONNECTED.message"));
        }
        if ((login = database.getDevelopmentLoginSpec()) == null) {
            this.showErrorDialog(this.resourceRepository().getString("YOU_MUST_DEFINE_A_DEVELOPMENT_LOGIN.message"));
            return false;
        }
        String driverName = login.getDriverClassName();
        if (driverName == null || driverName.equals("")) {
            this.showErrorDialog(this.resourceRepository().getString("NO_DATABASE_DRIVER_SPECIFIED.message"));
            return false;
        }
        String url = login.getURL();
        if (url == null || url.equals("")) {
            this.showErrorDialog(this.resourceRepository().getString("NO_URL_SPECIFIED.message"));
            return false;
        }
        return true;
    }

    private void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), message, this.resourceRepository().getString("ERROR_LOGGING_IN_TO_DATABASE.title"), 0);
    }
}

