/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GridLayout;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeAdapter;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

public abstract class AddRemovePanel
extends AbstractPanel {
    private Adapter adapter;
    private NodeSelector nodeSelector;
    private int buttonOrientation;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 3;
    public static final int TOP = 1;
    private JButton addButton;
    private JButton removeButton;
    private JButton optionalButton;
    private JButton upButton;
    private JButton downButton;
    private ObjectListSelectionModel rowSelectionModel;
    private PropertyValueModel selectedItemHolder;

    public AddRemovePanel(ApplicationContext context, Adapter adapter, ListValueModel listModel) {
        this(context, adapter, listModel, 2);
    }

    public AddRemovePanel(ApplicationContext context, Adapter adapter, ListValueModel listModel, int buttonOrientation) {
        this(context, adapter, listModel, buttonOrientation, new NodeSelector.DefaultNodeSelector());
    }

    public AddRemovePanel(ApplicationContext context, Adapter adapter, ListValueModel listModel, int buttonOrientation, NodeSelector nodeSelector) {
        super(context);
        this.adapter = adapter;
        this.buttonOrientation = buttonOrientation;
        this.nodeSelector = nodeSelector;
        this.initialize(listModel);
    }

    protected void initialize(ListValueModel listModel) {
        this.rowSelectionModel = this.buildRowSelectionModel(listModel);
        listModel.addListChangeListener(this.buildListChangeListener());
        this.selectedItemHolder = this.buildSelectedItemHolder();
        this.addButton = this.buildAddButton();
        this.removeButton = this.buildRemoveButton();
        this.optionalButton = this.buildOptionalButton(this.adapter instanceof OptionAdapter ? (OptionAdapter)this.adapter : null);
        this.upButton = this.buildUpButton(this.adapter instanceof UpDownAdapter ? (UpDownAdapter)this.adapter : null);
        this.downButton = this.buildDownButton(this.adapter instanceof UpDownAdapter ? (UpDownAdapter)this.adapter : null);
    }

    protected JMenuItem buildGoToMenuItem() {
        JMenuItem menuItem = new JMenuItem(this.resourceRepository().getString("SELECT_IN_NAVIGATOR_POPUP_MENU_ITEM"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        menuItem.addActionListener(this.buildGoToListener());
        return menuItem;
    }

    private ActionListener buildGoToListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRemovePanel.this.goToSelectedItem();
            }
        };
    }

    protected KeyListener buildF3KeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 114) {
                    AddRemovePanel.this.goToSelectedItem();
                }
            }
        };
    }

    private void goToSelectedItem() {
        if (this.getSelectedValue() != null) {
            this.nodeSelector.selectNodeFor(this.getSelectedValue());
        }
    }

    public Object getSelectedValue() {
        return this.getSelectionModel().getSelectedValue();
    }

    protected ObjectListSelectionModel buildRowSelectionModel(ListValueModel listModel) {
        ObjectListSelectionModel rowSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(listModel));
        rowSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        return rowSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AddRemovePanel.this.rowSelectionChanged(e);
                }
            }
        };
    }

    private void rowSelectionChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.getSelectionModel().getSelectedValuesSize() == 1) {
            this.selectedItemHolder.setValue(this.getSelectionModel().getSelectedValue());
        } else {
            this.selectedItemHolder.setValue(null);
        }
        this.updateButtons();
        this.fireListSelectionEvent(e);
    }

    private ListChangeListener buildListChangeListener() {
        return new ListChangeAdapter(){

            public void listChanged(ListChangeEvent e) {
                AddRemovePanel.this.updateButtons();
            }
        };
    }

    protected void updateButtons() {
        this.updateAddButton(this.addButton);
        this.updateRemoveButton(this.removeButton);
        this.updateOptionalButton(this.optionalButton);
        this.updateUpButton(this.upButton);
        this.updateDownButton(this.downButton);
    }

    protected void updateAddButton(JButton addButton) {
    }

    protected void updateRemoveButton(JButton removeButton) {
        removeButton.setEnabled(this.getSelectionModel().getSelectedValue() != null);
    }

    protected void updateOptionalButton(JButton optionalButton) {
        if (this.adapter instanceof OptionAdapter) {
            optionalButton.setEnabled(((OptionAdapter)this.adapter).enableOptionOnSelectionChange(this.rowSelectionModel));
        }
    }

    protected void updateUpButton(JButton upButton) {
        upButton.setEnabled(this.getSelectionModel().getMinSelectionIndex() > 0);
    }

    protected void updateDownButton(JButton downButton) {
        downButton.setEnabled(!this.getSelectionModel().isSelectionEmpty() && this.getSelectionModel().getMaxSelectionIndex() < this.getSelectionModel().getListModel().getSize() - 1);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listenerList.add(ListSelectionListener.class, listener);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listenerList.remove(ListSelectionListener.class, l);
    }

    private void fireListSelectionEvent(ListSelectionEvent e) {
        ListSelectionListener[] listeners = (ListSelectionListener[])this.listenerList.getListeners(ListSelectionListener.class);
        int index = listeners.length;
        while (--index >= 0) {
            listeners[index].valueChanged(e);
        }
    }

    private PropertyValueModel buildSelectedItemHolder() {
        return new SimplePropertyValueModel(null);
    }

    protected void initializeButtonPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JComponent buttonPanel = this.buildButtonPanel();
        if (this.buttonOrientation == 1) {
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.insets = new Insets(0, 0, 5, 0);
            constraints.anchor = 21;
            constraints.fill = 0;
        } else if (this.buttonOrientation == 4) {
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.insets = new Insets(0, 0, 0, 5);
            constraints.anchor = 19;
            constraints.fill = 2;
        } else if (this.buttonOrientation == 3) {
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.insets = new Insets(0, 5, 0, 0);
            constraints.anchor = 19;
            constraints.fill = 2;
        } else {
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.insets = new Insets(5, 0, 0, 0);
            constraints.anchor = 22;
            constraints.fill = 0;
        }
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        this.add((Component)buttonPanel, constraints);
    }

    protected void buildButtonPanel(JComponent buttonPanel) {
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.removeButton);
        buttonPanel.add(this.optionalButton);
        buttonPanel.add(this.upButton);
        buttonPanel.add(this.downButton);
    }

    private JComponent buildButtonPanel() {
        if (this.buttonOrientation == 4) {
            this.addAlignLeft(this.addButton);
            this.addAlignLeft(this.removeButton);
            this.addAlignLeft(this.optionalButton);
            this.addAlignLeft(this.upButton);
            this.addAlignLeft(this.downButton);
        } else if (this.buttonOrientation == 3) {
            this.addAlignRight(this.addButton);
            this.addAlignRight(this.removeButton);
            this.addAlignRight(this.optionalButton);
            this.addAlignRight(this.upButton);
            this.addAlignRight(this.downButton);
        }
        AccessibleTitledPanel panel = new AccessibleTitledPanel();
        this.buildButtonPanel(panel);
        int count = panel.getComponentCount();
        if (this.buttonOrientation == 4 || this.buttonOrientation == 3) {
            panel.setLayout(new GridLayout(count, 1, 0, 5));
        } else {
            panel.setLayout(new GridLayout(1, count, 5, 0));
        }
        return panel;
    }

    protected String addButtonKey() {
        return "ADD_BUTTON";
    }

    protected JButton buildAddButton() {
        JButton addButton = this.buildButton(this.addButtonKey());
        addButton.addActionListener(this.buildAddItemActionHandler());
        return addButton;
    }

    private ActionListener buildAddItemActionHandler() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRemovePanel.this.addNewItem();
            }
        };
    }

    protected void addNewItem() {
        this.getAdapter().addNewItem(this.getSelectionModel());
    }

    protected String removeButtonKey() {
        return "REMOVE_BUTTON";
    }

    protected JButton buildRemoveButton() {
        JButton removeButton = this.buildButton(this.removeButtonKey());
        removeButton.addActionListener(this.buildRemoveItemsActionHandler());
        removeButton.setEnabled(false);
        return removeButton;
    }

    private ActionListener buildRemoveItemsActionHandler() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRemovePanel.this.removeSelectedItems();
            }
        };
    }

    protected void removeSelectedItems() {
        this.getAdapter().removeSelectedItems(this.getSelectionModel());
    }

    protected JButton buildOptionalButton(OptionAdapter adapter) {
        JButton optionalButton = null;
        if (adapter != null) {
            optionalButton = this.buildButton(adapter.optionalButtonKey());
            optionalButton.addActionListener(this.buildOptionalActionHandler());
            optionalButton.setEnabled(false);
        } else {
            optionalButton = new JButton();
            optionalButton.setVisible(false);
        }
        return optionalButton;
    }

    private ActionListener buildOptionalActionHandler() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((OptionAdapter)AddRemovePanel.this.getAdapter()).optionOnSelection(AddRemovePanel.this.getSelectionModel());
            }
        };
    }

    protected String upButtonKey() {
        return "UP_BUTTON_TEXT";
    }

    protected JButton buildUpButton(UpDownAdapter adapter) {
        JButton upButton = null;
        if (adapter != null) {
            upButton = this.buildButton(this.upButtonKey());
            upButton.addActionListener(this.buildUpActionHandler());
            upButton.setEnabled(false);
        } else {
            upButton = new JButton();
            upButton.setVisible(false);
        }
        return upButton;
    }

    private ActionListener buildUpActionHandler() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRemovePanel.this.moveItemsUp();
            }
        };
    }

    protected void moveItemsUp() {
        Object[] selectedValues = this.getSelectionModel().getSelectedValues();
        ((UpDownAdapter)this.getAdapter()).moveItemsUp(selectedValues);
        this.getSelectionModel().setSelectedValues(selectedValues);
    }

    protected String downButtonKey() {
        return "DOWN_BUTTON_TEXT";
    }

    protected JButton buildDownButton(UpDownAdapter adapter) {
        JButton upButton = null;
        if (adapter != null) {
            upButton = this.buildButton(this.downButtonKey());
            upButton.addActionListener(this.buildDownActionHandler());
            upButton.setEnabled(false);
        } else {
            upButton = new JButton();
            upButton.setVisible(false);
        }
        return upButton;
    }

    private ActionListener buildDownActionHandler() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRemovePanel.this.moveItemsDown();
            }
        };
    }

    protected void moveItemsDown() {
        Object[] selectedValues = this.getSelectionModel().getSelectedValues();
        ((UpDownAdapter)this.getAdapter()).moveItemsDown(selectedValues);
        this.getSelectionModel().setSelectedValues(selectedValues);
    }

    public ObjectListSelectionModel getSelectionModel() {
        return this.rowSelectionModel;
    }

    public PropertyValueModel getSelectedItemHolder() {
        return this.selectedItemHolder;
    }

    protected Adapter getAdapter() {
        return this.adapter;
    }

    protected JButton getAddButton() {
        return this.addButton;
    }

    protected JButton getRemoveButton() {
        return this.removeButton;
    }

    protected JButton getOptionalButton() {
        return this.optionalButton;
    }

    protected int getButtonOrientation() {
        return this.buttonOrientation;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getComponent().setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        int selectedValuesSize = this.getSelectionModel().getSelectedValuesSize();
        this.removeButton.setEnabled(enabled && selectedValuesSize > 0);
        this.optionalButton.setEnabled(enabled && selectedValuesSize == 1);
    }

    public abstract JComponent getComponent();

    public void setOptionalButtonEnabled(boolean enabled) {
        this.optionalButton.setEnabled(enabled);
    }

    public void setRemoveButtonEnabled(boolean enabled) {
        this.removeButton.setEnabled(enabled);
    }

    public void setAddButtonEnabled(boolean enabled) {
        this.addButton.setEnabled(enabled);
    }

    public void setSelectedValue(Object anObject, boolean shouldScroll) {
        this.getSelectionModel().setSelectedValue(anObject);
    }

    public static interface UpDownOptionAdapter
    extends OptionAdapter,
    UpDownAdapter {
    }

    public static interface UpDownAdapter
    extends Adapter {
        public void moveItemsUp(Object[] var1);

        public void moveItemsDown(Object[] var1);
    }

    public static interface OptionAdapter
    extends Adapter {
        public String optionalButtonKey();

        public void optionOnSelection(ObjectListSelectionModel var1);

        public boolean enableOptionOnSelectionChange(ObjectListSelectionModel var1);
    }

    public static interface Adapter {
        public void addNewItem(ObjectListSelectionModel var1);

        public void removeSelectedItems(ObjectListSelectionModel var1);
    }
}

