/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.DisplayableStringConverter;
import org.eclipse.persistence.tools.workbench.uitools.FilteringListPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class NodeChooserDialog
extends AbstractDialog {
    private ApplicationNode[] nodes;
    private FilteringListPanel filteringPanel;
    private JList pathListBox;
    private static final Object[] EMPTY_LIST = new Object[0];

    public static NodeChooserDialog createDialog(ApplicationNode[] nodes, WorkbenchContext context) {
        Window window = context.getCurrentWindow();
        if (window instanceof Dialog) {
            return new NodeChooserDialog(nodes, context, (Dialog)window);
        }
        return new NodeChooserDialog(nodes, context);
    }

    private static String title(ApplicationContext context) {
        return context.getResourceRepository().getString("NODE_CHOOSER_DIALOG.TITLE");
    }

    private NodeChooserDialog(ApplicationNode[] nodes, WorkbenchContext context) {
        super(context, NodeChooserDialog.title(context.getApplicationContext()));
        this.initialize(nodes);
    }

    private NodeChooserDialog(ApplicationNode[] nodes, WorkbenchContext context, Dialog owner) {
        super(context, NodeChooserDialog.title(context.getApplicationContext()), owner);
        this.initialize(nodes);
    }

    private void initialize(ApplicationNode[] allNodes) {
        this.nodes = allNodes;
        Arrays.sort(this.nodes);
    }

    @Override
    protected Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        this.filteringPanel = new FilteringListPanel(this.nodes, null, DisplayableStringConverter.instance());
        this.configureLabel(this.filteringPanel.getTextFieldLabel(), "NODE_CHOOSER_DIALOG.TEXT_FIELD_LABEL");
        this.configureLabel(this.filteringPanel.getListBoxLabel(), "NODE_CHOOSER_DIALOG.NODE_LIST_BOX_LABEL");
        this.filteringPanel.setListBoxCellRenderer(new DisplayableListCellRenderer());
        this.filteringPanel.getListBox().getSelectionModel().addListSelectionListener(this.buildNodeListSelectionListener());
        this.filteringPanel.getListBox().addMouseListener(this.buildDoubleClickMouseListener());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 3.0;
        constraints.anchor = 19;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)this.filteringPanel, constraints);
        JPanel pathListPanel = new JPanel(new BorderLayout());
        JLabel pathListLabel = new JLabel();
        this.configureLabel(pathListLabel, "NODE_CHOOSER_DIALOG.PATH_LIST_BOX_LABEL");
        pathListLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        pathListPanel.add((Component)pathListLabel, "First");
        this.pathListBox = SwingComponentFactory.buildList();
        this.pathListBox.setDoubleBuffered(true);
        this.pathListBox.setCellRenderer(new DisplayableListCellRenderer());
        this.pathListBox.getSelectionModel().setSelectionMode(0);
        pathListLabel.setLabelFor(this.pathListBox);
        pathListPanel.add((Component)new JScrollPane(this.pathListBox), "Center");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 20;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)pathListPanel, constraints);
        return mainPanel;
    }

    private MouseListener buildDoubleClickMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NodeChooserDialog.this.clickOK();
                }
            }
        };
    }

    private void configureLabel(JLabel label, String key) {
        label.setText(this.resourceRepository().getString(key));
        label.setDisplayedMnemonic(this.resourceRepository().getMnemonic(key));
    }

    private ListSelectionListener buildNodeListSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    NodeChooserDialog.this.nodeSelectionChanged(e);
                }
            }
        };
    }

    @Override
    protected Action buildOKAction() {
        Action action = super.buildOKAction();
        action.setEnabled(false);
        return action;
    }

    @Override
    protected String helpTopicId() {
        return "dialog.nodeChooser";
    }

    @Override
    protected Component initialFocusComponent() {
        return this.filteringPanel.getTextField();
    }

    @Override
    protected void prepareToShow() {
        this.setSize(350, 566);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    protected void clickOK() {
        super.clickOK();
    }

    void nodeSelectionChanged(ListSelectionEvent e) {
        ApplicationNode selectedNode = (ApplicationNode)this.filteringPanel.getSelection();
        if (selectedNode == null) {
            this.pathListBox.setListData(EMPTY_LIST);
        } else {
            this.pathListBox.setListData(this.reversePathFor(selectedNode));
        }
        this.getOKAction().setEnabled(selectedNode != null);
    }

    private Object[] reversePathFor(ApplicationNode node) {
        TreeNodeValueModel[] path = node.path();
        Object[] shortPath = new Object[path.length - 1];
        System.arraycopy(path, 0, shortPath, 0, shortPath.length);
        return CollectionTools.reverse((Object[])shortPath);
    }

    public ApplicationNode selection() {
        if (!this.wasConfirmed()) {
            throw new IllegalStateException();
        }
        return (ApplicationNode)this.filteringPanel.getSelection();
    }
}

