/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.string;

import java.util.Comparator;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public interface PartialStringComparatorEngine {
    public StringHolderPair[] match(StringHolder[] var1, StringHolder[] var2);

    public static class SimpleStringHolderPair
    implements StringHolderPair {
        private final StringHolder stringHolder1;
        private final StringHolder stringHolder2;
        private final double score;

        public SimpleStringHolderPair(StringHolder stringHolder1, StringHolder stringHolder2, double score) {
            this.stringHolder1 = stringHolder1;
            this.stringHolder2 = stringHolder2;
            this.score = score;
        }

        @Override
        public StringHolder getStringHolder1() {
            return this.stringHolder1;
        }

        @Override
        public StringHolder getStringHolder2() {
            return this.stringHolder2;
        }

        @Override
        public double getScore() {
            return this.score;
        }

        public int compareTo(Object o) {
            return DEFAULT_COMPARATOR.compare(this, o);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            StringTools.buildSimpleToStringOn(this, sb);
            sb.append(" (");
            this.appendStringHolder(this.stringHolder1, sb);
            sb.append(" vs. ");
            this.appendStringHolder(this.stringHolder2, sb);
            sb.append(" => ");
            sb.append(this.score);
            sb.append(')');
            return sb.toString();
        }

        private void appendStringHolder(StringHolder stringHolder, StringBuffer sb) {
            if (stringHolder == null) {
                sb.append("<null>");
            } else {
                sb.append('\"');
                sb.append(stringHolder.getString());
                sb.append('\"');
            }
        }
    }

    public static interface StringHolderPair
    extends Comparable {
        public static final Comparator DEFAULT_COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                double score2;
                double score1 = ((StringHolderPair)o1).getScore();
                return score1 < (score2 = ((StringHolderPair)o2).getScore()) ? -1 : (score1 == score2 ? 0 : 1);
            }
        };

        public StringHolder getStringHolder1();

        public StringHolder getStringHolder2();

        public double getScore();
    }
}

