/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class Pipe {
    private final int bufferSize;
    private final byte[] buffer;
    private final long timeout;
    private final InputStream in = new InputStreamAdapter();
    private final OutputStream out = new OutputStreamAdapter();
    private boolean readLap = false;
    private int readIndex = 0;
    private boolean writeLap = false;
    private int writeIndex = 0;
    private boolean inputStreamClosed = false;
    private boolean outputStreamClosed = false;

    public Pipe() {
        this(2048);
    }

    public Pipe(int bufferSize) {
        this(bufferSize, 0L);
    }

    public Pipe(int bufferSize, long timeout) {
        this.bufferSize = bufferSize;
        this.buffer = new byte[bufferSize];
        this.timeout = timeout;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    synchronized int available() {
        if (this.inputStreamClosed) {
            return 0;
        }
        return this.bytesInPipe();
    }

    private int bytesInPipe() {
        int diff = this.writeIndex - this.readIndex;
        if (diff == 0) {
            return this.writeLap == this.readLap ? 0 : this.bufferSize;
        }
        return diff > 0 ? diff : diff + this.bufferSize;
    }

    synchronized int read() throws IOException {
        if (this.inputStreamClosed) {
            throw new IOException("Pipe closed");
        }
        long stop = System.currentTimeMillis() + this.timeout;
        long remaining = this.timeout;
        while (this.bytesInPipe() == 0) {
            if (this.outputStreamClosed) {
                return -1;
            }
            try {
                this.wait(remaining);
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException();
            }
            if (this.timeout > 0L && (remaining = stop - System.currentTimeMillis()) <= 0L) {
                throw new InterruptedIOException();
            }
            if (!this.inputStreamClosed) continue;
            throw new IOException("Pipe closed");
        }
        byte b = this.buffer[this.readIndex];
        ++this.readIndex;
        if (this.readIndex == this.bufferSize) {
            this.readLap = !this.readLap;
            this.readIndex = 0;
        }
        this.notifyAll();
        return b & 0xFF;
    }

    synchronized int read(byte[] b, int off, int len) throws IOException {
        int copyLength2;
        if (this.inputStreamClosed) {
            throw new IOException("Pipe closed");
        }
        long stop = System.currentTimeMillis() + this.timeout;
        long remaining = this.timeout;
        int bytesInPipe = this.bytesInPipe();
        while (bytesInPipe == 0) {
            if (this.outputStreamClosed) {
                return -1;
            }
            try {
                this.wait(remaining);
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException();
            }
            if (this.timeout > 0L && (remaining = stop - System.currentTimeMillis()) <= 0L) {
                throw new InterruptedIOException();
            }
            if (this.inputStreamClosed) {
                throw new IOException("Pipe closed");
            }
            bytesInPipe = this.bytesInPipe();
        }
        int copyLength1 = this.bufferSize - this.readIndex;
        int bytesRead = len > bytesInPipe ? bytesInPipe : len;
        if (copyLength1 > bytesRead) {
            copyLength1 = bytesRead;
        }
        System.arraycopy(this.buffer, this.readIndex, b, off, copyLength1);
        this.readIndex += copyLength1;
        if (this.readIndex == this.bufferSize) {
            this.readLap = !this.readLap;
            this.readIndex = 0;
        }
        if ((copyLength2 = bytesRead - copyLength1) > 0) {
            System.arraycopy(this.buffer, 0, b, off + copyLength1, copyLength2);
            this.readIndex += copyLength2;
        }
        this.notifyAll();
        return bytesRead;
    }

    synchronized void closeInputStream() {
        if (this.inputStreamClosed) {
            throw new IllegalStateException("InputStream already closed");
        }
        this.inputStreamClosed = true;
        this.outputStreamClosed = true;
        this.notifyAll();
    }

    private int freeSpace() {
        int diff = this.readIndex - this.writeIndex;
        if (diff == 0) {
            return this.writeLap == this.readLap ? this.bufferSize : 0;
        }
        return diff > 0 ? diff : diff + this.bufferSize;
    }

    synchronized void write(int b) throws IOException {
        if (this.outputStreamClosed) {
            throw new IOException("Pipe closed");
        }
        while (this.freeSpace() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException();
            }
            if (!this.outputStreamClosed) continue;
            throw new IOException("Pipe closed");
        }
        this.buffer[this.writeIndex] = (byte)b;
        ++this.writeIndex;
        if (this.writeIndex == this.bufferSize) {
            this.writeLap = !this.writeLap;
            this.writeIndex = 0;
        }
        this.notifyAll();
    }

    synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.outputStreamClosed) {
            throw new IOException("Pipe closed");
        }
        while (len > 0) {
            int copyLength2;
            int freeSpace = this.freeSpace();
            while (freeSpace == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    throw new InterruptedIOException();
                }
                if (this.outputStreamClosed) {
                    throw new IOException("Pipe closed");
                }
                freeSpace = this.freeSpace();
            }
            int copyLength1 = this.bufferSize - this.writeIndex;
            int tempLength = len > freeSpace ? freeSpace : len;
            if (copyLength1 > tempLength) {
                copyLength1 = tempLength;
            }
            System.arraycopy(b, off, this.buffer, this.writeIndex, copyLength1);
            this.writeIndex += copyLength1;
            if (this.writeIndex == this.bufferSize) {
                this.writeLap = !this.writeLap;
                this.writeIndex = 0;
            }
            if ((copyLength2 = tempLength - copyLength1) > 0) {
                System.arraycopy(b, off + copyLength1, this.buffer, 0, copyLength2);
                this.writeIndex += copyLength2;
            }
            off += tempLength;
            len -= tempLength;
            this.notifyAll();
        }
    }

    synchronized void closeOutputStream() {
        if (this.outputStreamClosed) {
            throw new IllegalStateException("OutputStream already closed");
        }
        this.outputStreamClosed = true;
        this.notifyAll();
    }

    private class OutputStreamAdapter
    extends OutputStream {
        OutputStreamAdapter() {
        }

        @Override
        public void write(int b) throws IOException {
            Pipe.this.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Pipe.this.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            Pipe.this.closeOutputStream();
        }
    }

    private class InputStreamAdapter
    extends InputStream {
        InputStreamAdapter() {
        }

        @Override
        public int available() throws IOException {
            return Pipe.this.available();
        }

        @Override
        public int read() throws IOException {
            return Pipe.this.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return Pipe.this.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            Pipe.this.closeInputStream();
        }
    }
}

