/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.NullDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.SimpleDiff;

public class EqualityDifferentiator
implements Differentiator {
    private static EqualityDifferentiator INSTANCE;

    public static synchronized Differentiator instance() {
        if (INSTANCE == null) {
            INSTANCE = new EqualityDifferentiator();
        }
        return INSTANCE;
    }

    private EqualityDifferentiator() {
    }

    @Override
    public Diff diff(Object object1, Object object2) {
        if (this.objectsAreIdentical(object1, object2)) {
            return new NullDiff(object1, object2, this);
        }
        return new SimpleDiff(object1, object2, this.descriptionTitle(), this);
    }

    private boolean objectsAreIdentical(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }

    private String descriptionTitle() {
        return "Objects are not equal";
    }

    @Override
    public Diff keyDiff(Object object1, Object object2) {
        return this.diff(object1, object2);
    }

    @Override
    public boolean comparesValueObjects() {
        return true;
    }

    public String toString() {
        return "EqualityDifferentiator";
    }
}

