/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.MemberRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class MethodHandleConstant
extends Constant {
    private short referenceKind;
    private short referenceIndex;

    MethodHandleConstant(ConstantPool pool, byte tag, ClassFileDataInputStream stream) throws IOException {
        super(pool, tag, stream);
    }

    @Override
    void initialize(ClassFileDataInputStream stream) throws IOException {
        this.referenceKind = stream.readU1();
        this.referenceIndex = stream.readU2();
    }

    @Override
    public void displayStringOn(IndentingPrintWriter writer) {
        super.displayStringOn(writer);
        writer.print(" kind: ");
        writer.print(this.referenceKind);
        MemberRefConstant ref = this.descriptor();
        writer.print(" class: ");
        writer.print(ref.className());
        writer.print("  name: ");
        writer.print(ref.name());
        writer.print("  descriptor: ");
        writer.println(ref.descriptor());
    }

    @Override
    public String description() {
        return "methodhandle";
    }

    public MemberRefConstant descriptor() {
        return (MemberRefConstant)this.getPool().get(this.referenceIndex);
    }

    @Override
    public Object value() {
        return null;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

