/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWColumnHandle
extends MWHandle {
    private volatile MWColumn column;
    private volatile String columnTableName;
    private volatile String columnName;

    private MWColumnHandle() {
    }

    public MWColumnHandle(MWModel parent, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
    }

    public MWColumnHandle(MWModel parent, MWColumn column, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
        this.column = column;
    }

    public MWColumn getColumn() {
        return this.column;
    }

    public void setColumn(MWColumn column) {
        this.column = column;
    }

    @Override
    protected Node node() {
        return this.getColumn();
    }

    public int compareTo(Object o) {
        return this.column.compareTo(((MWColumnHandle)o).column);
    }

    @Override
    public void toString(StringBuffer sb) {
        if (this.column == null) {
            sb.append("null");
        } else {
            this.column.toString(sb);
        }
    }

    public MWColumnHandle setScrubber(MWHandle.NodeReferenceScrubber scrubber) {
        this.setScrubberInternal(scrubber);
        return this;
    }

    @Override
    public void resolveColumnHandles() {
        MWTable table;
        super.resolveColumnHandles();
        if (this.columnTableName != null && this.columnName != null && (table = this.getDatabase().tableNamed(this.columnTableName)) != null) {
            this.column = table.columnNamed(this.columnName);
        }
        this.columnTableName = null;
        this.columnName = null;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWColumnHandle.class);
        descriptor.addDirectMapping("columnTableName", "getColumnTableNameForTopLink", "setColumnTableNameForTopLink", "column-table-name/text()");
        descriptor.addDirectMapping("columnName", "getColumnNameForTopLink", "setColumnNameForTopLink", "column-name/text()");
        return descriptor;
    }

    private String getColumnTableNameForTopLink() {
        return this.column == null ? null : this.column.getTable().getName();
    }

    private void setColumnTableNameForTopLink(String columnTableName) {
        this.columnTableName = columnTableName;
    }

    private String getColumnNameForTopLink() {
        return this.column == null ? null : this.column.getName();
    }

    private void setColumnNameForTopLink(String columnName) {
        this.columnName = columnName;
    }
}

