/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorInstantiationPolicy
extends MWAbstractDescriptorPolicy {
    private volatile String policyType;
    public static final String POLICY_TYPE_PROPERTY = "policyType";
    public static final String DEFAULT_CONSTRUCTOR = "Default constructor";
    public static final String METHOD = "Method";
    public static final String FACTORY = "Factory";
    private MWClassHandle factoryTypeHandle;
    public static final String FACTORY_TYPE_PROPERTY = "factoryType";
    private MWMethodHandle useMethodHandle;
    public static final String USE_METHOD_PROPERTY = "useMethod";
    private MWMethodHandle factoryMethodHandle;
    public static final String FACTORY_METHOD_PROPERTY = "factoryMethod";
    private MWMethodHandle instantiationMethodHandle;
    public static final String INSTANTIATION_METHOD_PROPERTY = "instantiationMethod";

    private MWDescriptorInstantiationPolicy() {
    }

    MWDescriptorInstantiationPolicy(MWMappingDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.policyType = DEFAULT_CONSTRUCTOR;
        this.factoryTypeHandle = new MWClassHandle(this, this.buildFactoryTypeScrubber());
        this.useMethodHandle = new MWMethodHandle(this, this.buildUseMethodScrubber());
        this.factoryMethodHandle = new MWMethodHandle(this, this.buildFactoryMethodScrubber());
        this.instantiationMethodHandle = new MWMethodHandle(this, this.buildInstantiationMethodScrubber());
    }

    public MWMethod getFactoryMethod() {
        return this.factoryMethodHandle.getMethod();
    }

    public void setFactoryMethod(MWMethod factoryMethod) {
        MWMethod old = this.getFactoryMethod();
        this.factoryMethodHandle.setMethod(factoryMethod);
        this.firePropertyChanged(FACTORY_METHOD_PROPERTY, old, factoryMethod);
    }

    public MWClass getFactoryType() {
        return this.factoryTypeHandle.getType();
    }

    public void setFactoryType(MWClass factoryType) {
        MWClass old = this.factoryTypeHandle.getType();
        this.factoryTypeHandle.setType(factoryType);
        this.firePropertyChanged(FACTORY_TYPE_PROPERTY, old, factoryType);
    }

    public MWMethod getInstantiationMethod() {
        return this.instantiationMethodHandle.getMethod();
    }

    public void setInstantiationMethod(MWMethod instantiationMethod) {
        MWMethod old = this.getInstantiationMethod();
        this.instantiationMethodHandle.setMethod(instantiationMethod);
        this.firePropertyChanged(INSTANTIATION_METHOD_PROPERTY, old, instantiationMethod);
    }

    public MWMethod getUseMethod() {
        return this.useMethodHandle.getMethod();
    }

    public void setUseMethod(MWMethod useMethod) {
        MWMethod old = this.getUseMethod();
        this.useMethodHandle.setMethod(useMethod);
        this.firePropertyChanged(USE_METHOD_PROPERTY, old, useMethod);
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(String policyType) {
        String old = this.policyType;
        this.policyType = policyType;
        this.firePropertyChanged(POLICY_TYPE_PROPERTY, old, policyType);
    }

    public boolean checkUseMethodLegitimacy() {
        return CollectionTools.contains(this.getOwningDescriptor().getMWClass().allMethods(), (Object)this.getUseMethod());
    }

    public boolean checkFactoryInstantiationMethodLegitimacy() {
        return CollectionTools.contains(this.getFactoryType().allMethods(), (Object)this.getInstantiationMethod());
    }

    public boolean checkFactoryMethodLegitimacy() {
        return CollectionTools.contains(this.getFactoryType().allMethods(), (Object)this.getFactoryMethod());
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.getPolicyType());
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.useMethodHandle);
        children.add(this.factoryMethodHandle);
        children.add(this.instantiationMethodHandle);
        children.add(this.factoryTypeHandle);
    }

    private MWHandle.NodeReferenceScrubber buildUseMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWDescriptorInstantiationPolicy.this.setUseMethod(null);
            }

            public String toString() {
                return "MWDescriptorInstantiationPolicy.buildUseMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildFactoryMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWDescriptorInstantiationPolicy.this.setFactoryMethod(null);
            }

            public String toString() {
                return "MWDescriptorInstantiationPolicy.buildFactoryMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildInstantiationMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWDescriptorInstantiationPolicy.this.setInstantiationMethod(null);
            }

            public String toString() {
                return "MWDescriptorInstantiationPolicy.buildInstantiationMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildFactoryTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWDescriptorInstantiationPolicy.this.setFactoryType(null);
            }

            public String toString() {
                return "MWDescriptorInstantiationPolicy.buildFactoryTypeScrubber()";
            }
        };
    }

    @Override
    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        String policyType = this.getPolicyType();
        if (policyType == DEFAULT_CONSTRUCTOR) {
            runtimeDescriptor.useDefaultConstructorInstantiationPolicy();
        } else if (policyType == METHOD) {
            MWMethod instantiationMethod = this.getUseMethod();
            if (instantiationMethod != null) {
                runtimeDescriptor.useMethodInstantiationPolicy(instantiationMethod.getName());
            }
        } else if (policyType == FACTORY) {
            MWClass factoryType = this.getFactoryType();
            if (factoryType == null) {
                return;
            }
            MWMethod instantiationMethod = this.getInstantiationMethod();
            if (instantiationMethod == null) {
                return;
            }
            String factoryClassName = factoryType.getName();
            MWMethod factoryMethod = this.getFactoryMethod();
            if (factoryMethod == null) {
                runtimeDescriptor.useFactoryInstantiationPolicy(factoryClassName, instantiationMethod.getName());
            } else {
                runtimeDescriptor.useFactoryInstantiationPolicy(factoryClassName, instantiationMethod.getName(), factoryMethod.getName());
            }
        } else {
            throw new IllegalStateException(policyType);
        }
    }

    @Override
    public MWDescriptorPolicy getPersistedPolicy() {
        return this;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.checkDefaultConstructor(problems);
        this.checkInstantiationMethod(problems);
        this.checkFactoryMethod(problems);
        this.checkFactoryInstantiationMethod(problems);
    }

    private void checkDefaultConstructor(List newProblems) {
        if (this.getPolicyType() == DEFAULT_CONSTRUCTOR && !this.getOwningDescriptor().getMWClass().hasAccessibleZeroArgumentConstructor()) {
            newProblems.add(this.buildProblem("0316"));
        }
    }

    private void checkInstantiationMethod(List newProblems) {
        if (this.getPolicyType() == METHOD) {
            if (this.getUseMethod() == null) {
                newProblems.add(this.buildProblem("0315"));
            } else if (!this.checkUseMethodLegitimacy()) {
                newProblems.add(this.buildProblem("0311"));
            } else if (!this.getUseMethod().isCandidateInstantiationMethod()) {
                newProblems.add(this.buildProblem("0343"));
            }
        }
    }

    private void checkFactoryMethod(List newProblems) {
        if (this.getPolicyType() == FACTORY && this.getFactoryMethod() != null && this.getFactoryType() != null) {
            if (!this.checkFactoryMethodLegitimacy()) {
                newProblems.add(this.buildProblem("0313"));
            } else if (!this.getFactoryMethod().isCandidateFactoryMethod()) {
                newProblems.add(this.buildProblem("0345"));
            }
        }
    }

    private void checkFactoryInstantiationMethod(List newProblems) {
        if (this.getPolicyType() == FACTORY) {
            if (this.getInstantiationMethod() == null) {
                newProblems.add(this.buildProblem("0314"));
            } else if (this.getFactoryType() != null) {
                if (!this.checkFactoryInstantiationMethodLegitimacy()) {
                    newProblems.add(this.buildProblem("0312"));
                } else if (!this.getInstantiationMethod().isCandidateFactoryInstantiationMethodFor(this.getFactoryType())) {
                    newProblems.add(this.buildProblem("0344"));
                }
            }
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDescriptorInstantiationPolicy.class);
        ObjectTypeConverter policyTypeConverter = new ObjectTypeConverter();
        policyTypeConverter.addConversionValue((Object)DEFAULT_CONSTRUCTOR, (Object)DEFAULT_CONSTRUCTOR);
        policyTypeConverter.addConversionValue((Object)FACTORY, (Object)FACTORY);
        policyTypeConverter.addConversionValue((Object)METHOD, (Object)METHOD);
        XMLDirectMapping policyTypeMapping = new XMLDirectMapping();
        policyTypeMapping.setAttributeName(POLICY_TYPE_PROPERTY);
        policyTypeMapping.setXPath("policy-type/text()");
        policyTypeMapping.setConverter((Converter)policyTypeConverter);
        descriptor.addMapping((DatabaseMapping)policyTypeMapping);
        XMLCompositeObjectMapping factoryTypeHandleMapping = new XMLCompositeObjectMapping();
        factoryTypeHandleMapping.setAttributeName("factoryTypeHandle");
        factoryTypeHandleMapping.setSetMethodName("setFactoryTypeHandleForTopLink");
        factoryTypeHandleMapping.setGetMethodName("getFactoryTypeHandleForTopLink");
        factoryTypeHandleMapping.setReferenceClass(MWClassHandle.class);
        factoryTypeHandleMapping.setXPath("factory-type-handle");
        descriptor.addMapping((DatabaseMapping)factoryTypeHandleMapping);
        XMLCompositeObjectMapping useMethodHandleMapping = new XMLCompositeObjectMapping();
        useMethodHandleMapping.setAttributeName("useMethodHandle");
        useMethodHandleMapping.setSetMethodName("setUseMethodHandleForTopLink");
        useMethodHandleMapping.setGetMethodName("getUseMethodHandleForTopLink");
        useMethodHandleMapping.setReferenceClass(MWMethodHandle.class);
        useMethodHandleMapping.setXPath("use-method-handle");
        descriptor.addMapping((DatabaseMapping)useMethodHandleMapping);
        XMLCompositeObjectMapping factoryMethodHandleMapping = new XMLCompositeObjectMapping();
        factoryMethodHandleMapping.setAttributeName("factoryMethodHandle");
        factoryMethodHandleMapping.setSetMethodName("setFactoryMethodHandleForTopLink");
        factoryMethodHandleMapping.setGetMethodName("getFactoryMethodHandleForTopLink");
        factoryMethodHandleMapping.setReferenceClass(MWMethodHandle.class);
        factoryMethodHandleMapping.setXPath("factory-method-handle");
        descriptor.addMapping((DatabaseMapping)factoryMethodHandleMapping);
        XMLCompositeObjectMapping instantiationMethodHandleMapping = new XMLCompositeObjectMapping();
        instantiationMethodHandleMapping.setAttributeName("instantiationMethodHandle");
        instantiationMethodHandleMapping.setSetMethodName("setInstantiationMethodHandleForTopLink");
        instantiationMethodHandleMapping.setGetMethodName("getInstantiationMethodHandleForTopLink");
        instantiationMethodHandleMapping.setReferenceClass(MWMethodHandle.class);
        instantiationMethodHandleMapping.setXPath("isntantiation-method-handle");
        descriptor.addMapping((DatabaseMapping)instantiationMethodHandleMapping);
        return descriptor;
    }

    private MWClassHandle getFactoryTypeHandleForTopLink() {
        return this.factoryTypeHandle.getType() == null ? null : this.factoryTypeHandle;
    }

    private void setFactoryTypeHandleForTopLink(MWClassHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildFactoryTypeScrubber();
        this.factoryTypeHandle = handle == null ? new MWClassHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWMethodHandle getUseMethodHandleForTopLink() {
        return this.useMethodHandle.getMethod() == null ? null : this.useMethodHandle;
    }

    private void setUseMethodHandleForTopLink(MWMethodHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildUseMethodScrubber();
        this.useMethodHandle = handle == null ? new MWMethodHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWMethodHandle getFactoryMethodHandleForTopLink() {
        return this.factoryMethodHandle.getMethod() == null ? null : this.factoryMethodHandle;
    }

    private void setFactoryMethodHandleForTopLink(MWMethodHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildFactoryMethodScrubber();
        this.factoryMethodHandle = handle == null ? new MWMethodHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWMethodHandle getInstantiationMethodHandleForTopLink() {
        return this.instantiationMethodHandle.getMethod() == null ? null : this.instantiationMethodHandle;
    }

    private void setInstantiationMethodHandleForTopLink(MWMethodHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildInstantiationMethodScrubber();
        this.instantiationMethodHandle = handle == null ? new MWMethodHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

