/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class QuickViewPanel
extends AbstractSubjectPanel {
    private QuickViewModel quickViewModel;

    protected QuickViewPanel(ValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    @Override
    protected void initialize(ValueModel subjectHolder) {
        super.initialize(subjectHolder);
        this.quickViewModel = new QuickViewModel();
        this.getSubjectHolder().addPropertyChangeListener("value", this.buildSubjectHolderListener());
        this.quickViewModel.setParentNode((Node)((AbstractNodeModel)this.subject()));
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel quickViewLabel = this.buildLabel("QUICK_VIEW_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)quickViewLabel, constraints);
        JList list = SwingComponentFactory.buildList(this.buildQuickViewListAdapter());
        list.setCellRenderer(new QuickViewRenderer());
        list.addListSelectionListener(this.buildListSelectionListener());
        list.addFocusListener(this.buildListFocusListener());
        list.addMouseListener(this.buildMouseListener());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.getViewport().setPreferredSize(new Dimension(0, 0));
        this.add((Component)scrollPane, constraints);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)buttonPanel, constraints);
        JButton removeButton = this.buildButton("QUICK_VIEW_REMOVE_BUTTON");
        removeButton.putClientProperty("list", list);
        removeButton.addActionListener(this.buildRemoveActionListener());
        removeButton.setEnabled(false);
        buttonPanel.add(removeButton);
        list.putClientProperty("remove", removeButton);
    }

    private MouseListener buildMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                JList list = (JList)e.getComponent();
                Rectangle cellBounds = list.getCellBounds(index = list.locationToIndex(e.getPoint()), index);
                if (cellBounds != null && cellBounds.width > 0 && cellBounds.height > 0) {
                    ((QuickViewItem)list.getModel().getElementAt(index)).select();
                }
            }
        };
    }

    private FocusListener buildListFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ((JList)e.getSource()).repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ((JList)e.getSource()).repaint();
            }
        };
    }

    private ListSelectionListener buildListSelectionListener() {
        return new ListSelectionListener(){

            private void updateRemoveButtonEnablement(JButton removeButton, Object[] values) {
                boolean enabled;
                boolean bl = enabled = values.length > 0;
                if (enabled) {
                    for (int index = 0; index < values.length; ++index) {
                        QuickViewItem item = (QuickViewItem)values[index];
                        enabled &= item.isRemovable();
                    }
                }
                removeButton.setEnabled(enabled);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                JList list = (JList)e.getSource();
                Object[] values = list.getSelectedValues();
                JButton removeButton = (JButton)list.getClientProperty("remove");
                this.updateRemoveButtonEnablement(removeButton, values);
            }
        };
    }

    private ListModel buildQuickViewListAdapter() {
        return new ListModelAdapter(this.buildQuickViewListValueModel());
    }

    private ListValueModel buildQuickViewListValueModel() {
        return new ListAspectAdapter("items", (Model)this.quickViewModel){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((QuickViewModel)((Object)this.subject)).items();
            }

            @Override
            protected int sizeFromSubject() {
                return ((QuickViewModel)((Object)this.subject)).itemsSize();
            }
        };
    }

    private ActionListener buildRemoveActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton button = (JButton)e.getSource();
                JList list = (JList)button.getClientProperty("list");
                Object[] values = list.getSelectedValues();
                for (int index = 0; index < values.length; ++index) {
                    ((QuickViewItem)values[index]).remove();
                }
            }
        };
    }

    protected abstract QuickViewSectionFactory buildSectionFactory(Node var1);

    private PropertyChangeListener buildSubjectHolderListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                QuickViewPanel.this.quickViewModel.setParentNode((Node)QuickViewPanel.this.subject());
            }
        };
    }

    private class QuickViewSectionRenderer
    implements ListCellRenderer {
        private QuickViewSectionRenderer() {
        }

        private Color getBackground(JList list, boolean selected, boolean hasFocus) {
            if (selected) {
                if (hasFocus) {
                    return list.getSelectionBackground();
                }
                return UIManager.getColor("Panel.background");
            }
            return list.getBackground();
        }

        private Border getBorder(JList list, int index, boolean selected, boolean hasFocus) {
            Border border = selected ? (hasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Panel.background").darker()), BorderFactory.createMatteBorder(1, 1, 0, 1, UIManager.getColor("Panel.background")))) : BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Panel.background")), BorderFactory.createEmptyBorder(1, 1, 0, 1));
            return this.updateBorder(border, index);
        }

        private Color getForeground(JList list, boolean selected, boolean hasFocus) {
            if (selected) {
                if (hasFocus) {
                    return list.getSelectionForeground();
                }
                return UIManager.getColor("Panel.foreground");
            }
            return list.getForeground();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            JLabel label = new JLabel();
            this.updateUI(label, (QuickViewSection)value, list, index, selected, hasFocus);
            return label;
        }

        private Border updateBorder(Border border, int index) {
            if (index > 0) {
                return BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 0, 0, UIManager.getColor("List.background")), border);
            }
            return border;
        }

        private void updateUI(JLabel label, QuickViewSection section, JList list, int index, boolean selected, boolean hasFocus) {
            Color background = this.getBackground(list, selected, hasFocus);
            Color foreground = this.getForeground(list, selected, hasFocus);
            Border border = this.getBorder(list, index, selected, hasFocus);
            label.setOpaque(true);
            label.setBackground(background);
            label.setBorder(border);
            label.setComponentOrientation(list.getComponentOrientation());
            label.setEnabled(list.isEnabled());
            label.setForeground(foreground);
            label.setIcon(section.icon());
            label.setText(section.displayString());
            label.getAccessibleContext().setAccessibleName(section.accessibleName());
            Font listFont = list.getFont();
            label.setFont(new Font(listFont.getName(), 1, listFont.getSize()));
        }
    }

    private class QuickViewRenderer
    implements ListCellRenderer {
        private ListCellRenderer[] cachedRenderers;
        private static final int ITEM_RENDERER = 0;
        private static final int SECTION_RENDERER = 1;

        QuickViewRenderer() {
            this.initialize();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            ListCellRenderer renderer = this.retrieveCellRenderer(value);
            return renderer.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }

        private void initialize() {
            this.cachedRenderers = new ListCellRenderer[3];
            this.cachedRenderers[0] = new QuickViewItemRenderer();
            this.cachedRenderers[1] = new QuickViewSectionRenderer();
        }

        private ListCellRenderer retrieveCellRenderer(Object value) {
            if (value instanceof QuickViewSection) {
                return this.cachedRenderers[1];
            }
            return this.cachedRenderers[0];
        }
    }

    private class QuickViewModel
    extends AbstractNodeModel {
        public List items;
        private List sectionSynchronizers;
        public static final String ITEMS_LIST = "items";

        private QuickViewModel() {
        }

        protected final void checkParent(Node parent) {
        }

        private void disengageListeners() {
            for (SectionSynchronizer synchronizer : this.sectionSynchronizers) {
                synchronizer.disengageListeners();
            }
        }

        public final String displayString() {
            return null;
        }

        protected void initialize() {
            super.initialize();
            this.items = new Vector();
            this.sectionSynchronizers = new Vector();
        }

        public ListIterator items() {
            return this.items.listIterator();
        }

        public int itemsSize() {
            return this.items.size();
        }

        public final void setParentNode(Node parentNode) {
            if (this.getParent() != null) {
                this.disengageListeners();
                this.removeItemsFromList(0, this.items.size(), this.items, ITEMS_LIST);
                this.sectionSynchronizers.clear();
                this.items.clear();
            }
            super.setParent(parentNode);
            if (parentNode != null) {
                this.updateItems();
            }
        }

        private void updateItems() {
            QuickViewSection[] sections = QuickViewPanel.this.buildSectionFactory(this.getParent()).buildSections();
            for (int index = 0; index < sections.length; ++index) {
                QuickViewSection section = sections[index];
                this.items.add(section);
                SectionSynchronizer synchronizer = new SectionSynchronizer(section, this.items.size());
                this.sectionSynchronizers.add(synchronizer);
                CollectionTools.addAll((Collection)this.items, (Iterator)synchronizer.items());
            }
            this.fireItemsAdded(ITEMS_LIST, 0, this.items);
        }

        private class SectionSynchronizer {
            private int index;
            private ListValueModel itemsHolder;
            private ListChangeListener listener;

            SectionSynchronizer(QuickViewSection section, int index) {
                this.initialize(section, index);
            }

            public void disengageListeners() {
                this.itemsHolder.removeListChangeListener("value", this.listener);
            }

            private void initialize(QuickViewSection section, int index) {
                this.index = index;
                this.listener = new ListChangeHandler();
                this.itemsHolder = section.buildItemsHolder();
                this.itemsHolder.addListChangeListener("value", this.listener);
            }

            Iterator items() {
                return (Iterator)this.itemsHolder.getValue();
            }

            int itemsSize() {
                return this.itemsHolder.size();
            }

            private void updateSectionsIndex(SectionSynchronizer previousSynchronizer) {
                for (int index = 1 + QuickViewModel.this.sectionSynchronizers.indexOf(previousSynchronizer); index < QuickViewModel.this.sectionSynchronizers.size(); ++index) {
                    SectionSynchronizer synchronizer = (SectionSynchronizer)QuickViewModel.this.sectionSynchronizers.get(index);
                    synchronizer.index = previousSynchronizer.itemsSize() + previousSynchronizer.index + 1;
                    previousSynchronizer = synchronizer;
                }
            }

            private class ListChangeHandler
            implements ListChangeListener {
                private ListChangeHandler() {
                }

                public void itemsAdded(ListChangeEvent e) {
                    QuickViewModel.this.addItemsToList(SectionSynchronizer.this.index + e.getIndex(), CollectionTools.list((Iterator)e.items()), QuickViewModel.this.items, QuickViewModel.ITEMS_LIST);
                    SectionSynchronizer.this.updateSectionsIndex(SectionSynchronizer.this);
                }

                public void itemsRemoved(ListChangeEvent e) {
                    int size = SectionSynchronizer.this.itemsHolder.size();
                    QuickViewModel.this.removeItemsFromList(SectionSynchronizer.this.index + e.getIndex(), e.size(), QuickViewModel.this.items, QuickViewModel.ITEMS_LIST);
                    SectionSynchronizer.this.updateSectionsIndex(SectionSynchronizer.this);
                }

                public void itemsReplaced(ListChangeEvent e) {
                    QuickViewModel.this.removeItemsFromList(SectionSynchronizer.this.index + e.getIndex(), e.size(), QuickViewModel.this.items, QuickViewModel.ITEMS_LIST);
                    QuickViewModel.this.addItemsToList(SectionSynchronizer.this.index + e.getIndex(), CollectionTools.list((Iterator)e.items()), QuickViewModel.this.items, QuickViewModel.ITEMS_LIST);
                }

                public void listChanged(ListChangeEvent e) {
                }
            }
        }
    }

    private class QuickViewItemRenderer
    extends SimpleListCellRenderer {
        private QuickViewItemRenderer() {
        }

        @Override
        public String buildAccessibleName(Object value) {
            return ((QuickViewItem)value).accessibleName();
        }

        @Override
        protected Icon buildIcon(Object value) {
            return ((QuickViewItem)value).icon();
        }

        @Override
        protected String buildText(Object value) {
            return ((QuickViewItem)value).displayString();
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            QuickViewItemRenderer renderer = new QuickViewItemRenderer();
            renderer.getListCellRendererComponentInternal(list, value, index, selected, hasFocus);
            renderer.updateBackground(list, selected);
            renderer.updateBorder();
            return renderer;
        }

        private Component getListCellRendererComponentInternal(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            return super.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }

        private void updateBackground(JList list, boolean selected) {
            if (selected) {
                if (list.hasFocus()) {
                    this.setBackground(list.getSelectionBackground());
                } else {
                    this.setBackground(UIManager.getColor("Panel.background"));
                }
            } else {
                this.setBackground(list.getBackground());
            }
        }

        private void updateBorder() {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 5, 0, 0, UIManager.getColor("List.background")), this.getBorder()));
        }
    }

    protected static interface QuickViewSectionFactory {
        public QuickViewSection[] buildSections();
    }

    protected static interface QuickViewSection
    extends QuickViewItem {
        public ListValueModel buildItemsHolder();
    }

    public static interface QuickViewItem {
        public void select();

        public Object getValue();

        public boolean isRemovable();

        public void remove();

        public String displayString();

        public Icon icon();

        public String accessibleName();
    }
}

