/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

final class ReadOnlyFileDialog
extends AbstractDialog {
    private Vector files;
    private boolean saveAsWasPressed;

    ReadOnlyFileDialog(WorkbenchContext context, Collection files) {
        super(context);
        this.files = (Vector)CollectionTools.sort(new Vector(files));
    }

    @Override
    protected String helpTopicId() {
        return "dialog.readOnly";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("versionControlAssistance.title"));
    }

    @Override
    protected Component buildMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JTextArea descriptionLabel = new JTextArea(this.resourceRepository().getString("versionControlAssistance.message"), 0, 50);
        descriptionLabel.setLineWrap(true);
        descriptionLabel.setWrapStyleWord(true);
        descriptionLabel.setBackground(this.getBackground());
        descriptionLabel.setFont(this.getFont());
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 21;
        constraints.fill = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)descriptionLabel, constraints);
        JList fileListBox = SwingComponentFactory.buildList(this.files);
        JLabel title = new JLabel(this.resourceRepository().getString("readOnlyFiles"));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.anchor = 21;
        constraints.fill = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)title, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)new JScrollPane(fileListBox), constraints);
        return panel;
    }

    @Override
    protected String buildOKText() {
        return this.resourceRepository().getString("save");
    }

    @Override
    protected Iterator buildCustomActions() {
        return new SingleElementIterator((Object)this.buildSaveAsAction());
    }

    private Action buildSaveAsAction() {
        return new AbstractFrameworkAction(this.getWorkbenchContext()){

            @Override
            protected void initialize() {
                this.initializeTextAndMnemonic("saveAs");
            }

            @Override
            protected void execute() {
                ReadOnlyFileDialog.this.saveAsPressed();
            }
        };
    }

    void saveAsPressed() {
        if (this.preConfirm()) {
            this.saveAsWasPressed = true;
            this.dispose();
        }
    }

    boolean saveAsWasPressed() {
        return this.saveAsWasPressed;
    }

    boolean saveWasPressed() {
        return this.wasConfirmed();
    }
}

