/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkNodeManager;

final class WorkbenchCloseAction
extends AbstractFrameworkAction {
    private FrameworkNodeManager nodeManager;
    private TreeSelectionListener treeSelectionListener;
    private WindowListener windowListener;

    WorkbenchCloseAction(WorkbenchContext context, FrameworkNodeManager nodeManager) {
        super(context);
        this.nodeManager = nodeManager;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("file.close");
        this.initializeIcon("file.close");
        this.initializeToolTipText("file.close.toolTipText");
        this.initializeAccelerator("file.close.ACCELERATOR");
        this.treeSelectionListener = this.buildTreeSelectionListener();
        this.windowListener = this.buildWorkbenchWindowListener();
        this.currentWindow().addWindowListener(this.windowListener);
        this.navigatorSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
        this.updateEnabledState();
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(TreeSelectionEvent e) {
                WorkbenchCloseAction workbenchCloseAction = WorkbenchCloseAction.this;
                synchronized (workbenchCloseAction) {
                    WorkbenchCloseAction.this.update();
                }
            }
        };
    }

    private WindowListener buildWorkbenchWindowListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                WorkbenchCloseAction.this.workbenchWindowClosed();
            }
        };
    }

    void update() {
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        this.setEnabled(this.selectedProjectNodes().length > 0);
    }

    @Override
    protected void execute() {
        this.nodeManager.close(this.selectedProjectNodes(), this.getWorkbenchContext());
    }

    void workbenchWindowClosed() {
        this.navigatorSelectionModel().removeTreeSelectionListener(this.treeSelectionListener);
        this.currentWindow().removeWindowListener(this.windowListener);
    }
}

