/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.string;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class StringTools {
    public static final String CR = System.getProperty("line.separator");
    public static final String EMPTY_STRING = "";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int MINIMUM_MATCHING_LETTER = 2;
    public static final int NO_MATCH = 0;
    public static final int STRING_CONTAINS = 6;
    public static final int STRING_CONTAINS_PART = 2;
    public static final int STRING_CONTAINS_PART_CONTINUOUS = 4;
    public static final int STRINGS_EQUAL = 10;
    public static final int STRINGS_EQUAL_WITH_IGNORE_CHARACTERS = 8;
    private static final char[] VOWELS = new char[]{'a', 'e', 'i', 'o', 'u'};

    public static String pad(String string, int length) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.padInternal(string, length);
    }

    public static String padOrTruncate(String string, int length) {
        int stringLength = string.length();
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return string.substring(0, length);
        }
        return StringTools.padInternal(string, length);
    }

    private static String padInternal(String string, int length) {
        char[] a = new char[length];
        int stringLength = string.length();
        string.getChars(0, stringLength, a, 0);
        Arrays.fill(a, stringLength, length, ' ');
        return new String(a);
    }

    public static String zeroPad(String string, int length) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.zeroPadInternal(string, length);
    }

    public static String zeroPadOrTruncate(String string, int length) {
        int stringLength = string.length();
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return string.substring(stringLength - length);
        }
        return StringTools.zeroPadInternal(string, length);
    }

    private static String zeroPadInternal(String string, int length) {
        char[] a = new char[length];
        int stringLength = string.length();
        int padLength = length - stringLength;
        string.getChars(0, stringLength, a, padLength);
        Arrays.fill(a, 0, padLength, '0');
        return new String(a);
    }

    public static String removeFirstOccurrence(String string, char character) {
        int index = string.indexOf(character);
        if (index == -1) {
            return string;
        }
        if (index == 0) {
            return string.substring(1);
        }
        int last = string.length() - 1;
        if (index == last) {
            return string.substring(0, last);
        }
        return string.substring(0, index).concat(string.substring(index + 1));
    }

    public static String removeAllOccurrences(String string, char character) {
        StringBuffer sb = new StringBuffer(string.length());
        StringTools.removeAllOccurrencesOn(string, character, sb);
        return sb.toString();
    }

    public static void removeAllOccurrencesOn(String string, char character, StringBuffer sb) {
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == character) continue;
            sb.append(c);
        }
    }

    public static String removeAllSpaces(String string) {
        return StringTools.removeAllOccurrences(string, ' ');
    }

    public static int commonPrefixLength(String s1, String s2) {
        return StringTools.commonPrefixLength(s1.toCharArray(), s2.toCharArray());
    }

    public static int commonPrefixLength(char[] s1, char[] s2) {
        return StringTools.commonPrefixLengthInternal(s1, s2, Math.min(s1.length, s2.length));
    }

    public static int commonPrefixLength(String s1, String s2, int max) {
        return StringTools.commonPrefixLength(s1.toCharArray(), s2.toCharArray());
    }

    public static int commonPrefixLength(char[] s1, char[] s2, int max) {
        return StringTools.commonPrefixLengthInternal(s1, s2, Math.min(max, Math.min(s1.length, s2.length)));
    }

    private static int commonPrefixLengthInternal(char[] s1, char[] s2, int max) {
        for (int i = 0; i < max; ++i) {
            if (s1[i] == s2[i]) continue;
            return i;
        }
        return max;
    }

    private static char[] capitalizeInternal(char[] string) {
        string[0] = Character.toUpperCase(string[0]);
        return string;
    }

    public static char[] capitalize(char[] string) {
        if (string.length == 0 || Character.isUpperCase(string[0])) {
            return string;
        }
        return StringTools.capitalizeInternal(string);
    }

    public static String capitalize(String string) {
        if (string.length() == 0 || Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        return new String(StringTools.capitalizeInternal(string.toCharArray()));
    }

    private static void capitalizeOnInternal(char[] string, StringBuffer sb) {
        sb.append(Character.toUpperCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void capitalizeOn(char[] string, StringBuffer sb) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            sb.append(string);
        } else {
            StringTools.capitalizeOnInternal(string, sb);
        }
    }

    public static void capitalizeOn(String string, StringBuffer sb) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            sb.append(string);
        } else {
            StringTools.capitalizeOnInternal(string.toCharArray(), sb);
        }
    }

    private static void capitalizeOnInternal(char[] string, Writer writer) {
        try {
            writer.write(Character.toUpperCase(string[0]));
            writer.write(string, 1, string.length - 1);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeStringOn(char[] string, Writer writer) {
        try {
            writer.write(string);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void capitalizeOn(char[] string, Writer writer) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.capitalizeOnInternal(string, writer);
        }
    }

    private static void writeStringOn(String string, Writer writer) {
        try {
            writer.write(string);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void capitalizeOn(String string, Writer writer) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.capitalizeOnInternal(string.toCharArray(), writer);
        }
    }

    private static char[] uncapitalizeInternal(char[] string) {
        string[0] = Character.toLowerCase(string[0]);
        return string;
    }

    private static boolean stringNeedNotBeUncapitalized(char[] string) {
        if (string.length == 0) {
            return true;
        }
        return Character.isLowerCase(string[0]);
    }

    private static boolean stringNeedNotBeUncapitalizedJavaBean(char[] string) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            return true;
        }
        return string.length > 1 && Character.isUpperCase(string[1]) && Character.isUpperCase(string[0]);
    }

    public static char[] uncapitalizeJavaBean(char[] string) {
        if (StringTools.stringNeedNotBeUncapitalizedJavaBean(string)) {
            return string;
        }
        return StringTools.uncapitalizeInternal(string);
    }

    public static char[] uncapitalize(char[] string) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            return string;
        }
        return StringTools.uncapitalizeInternal(string);
    }

    private static boolean stringNeedNotBeUncapitalized(String string) {
        if (string.length() == 0) {
            return true;
        }
        return Character.isLowerCase(string.charAt(0));
    }

    private static boolean stringNeedNotBeUncapitalizedJavaBean(String string) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            return true;
        }
        return string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0));
    }

    public static String uncapitalizeJavaBean(String string) {
        if (StringTools.stringNeedNotBeUncapitalizedJavaBean(string)) {
            return string;
        }
        return new String(StringTools.uncapitalizeInternal(string.toCharArray()));
    }

    public static String uncapitalize(String string) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            return string;
        }
        return new String(StringTools.uncapitalizeInternal(string.toCharArray()));
    }

    private static void uncapitalizeOnInternal(char[] string, StringBuffer sb) {
        sb.append(Character.toLowerCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void uncapitalizeOn(char[] string, StringBuffer sb) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOnInternal(string, sb);
        }
    }

    public static void uncapitalizeOn(String string, StringBuffer sb) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOnInternal(string.toCharArray(), sb);
        }
    }

    private static void uncapitalizeOnInternal(char[] string, Writer writer) {
        try {
            writer.write(Character.toLowerCase(string[0]));
            writer.write(string, 1, string.length - 1);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void uncapitalizeOn(char[] string, Writer writer) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.uncapitalizeOnInternal(string, writer);
        }
    }

    public static void uncapitalizeOn(String string, Writer writer) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.uncapitalizeOnInternal(string.toCharArray(), writer);
        }
    }

    public static String buildToStringFor(Object o, Object additionalInfo) {
        StringBuffer sb = new StringBuffer();
        StringTools.buildSimpleToStringOn(o, sb);
        sb.append(" (");
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String buildToStringFor(Object o) {
        StringBuffer sb = new StringBuffer();
        StringTools.buildSimpleToStringOn(o, sb);
        return sb.toString();
    }

    public static void buildSimpleToStringOn(Object o, StringBuffer sb) {
        sb.append(ClassTools.toStringClassNameForObject(o));
        sb.append('[');
        sb.append(StringTools.zeroPad(Integer.toHexString(System.identityHashCode(o)).toUpperCase(), 8));
        sb.append(']');
    }

    public static boolean stringIsEmpty(String text) {
        if (text == null || text.length() == 0) {
            return true;
        }
        int i = text.length();
        while (i-- > 0) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean stringsAreEqualIgnoreCase(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean stringsAreEqual(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean charIsVowel(char c) {
        return CollectionTools.contains(VOWELS, Character.toLowerCase(c));
    }

    public static String replaceHTMLBreaks(String string) {
        return string.replaceAll("<br>", CR).replaceAll("<BR>", CR);
    }

    public static String convertCamelBackToAllCaps(String camelBackString) {
        int len = camelBackString.length();
        if (len == 0) {
            return EMPTY_STRING;
        }
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelBackString.charAt(0);
        StringBuffer sb = new StringBuffer(len * 2);
        for (int i = 1; i <= len; ++i) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelBackString.charAt(i);
            if (StringTools.camelBackWordBreak(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
        }
        return sb.toString();
    }

    public static String convertCamelBackToAllCaps(String camelBackString, int maxLength) {
        int len = camelBackString.length();
        if (len == 0 || maxLength == 0) {
            return EMPTY_STRING;
        }
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelBackString.charAt(0);
        StringBuffer sb = new StringBuffer(maxLength);
        for (int i = 1; i <= len; ++i) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelBackString.charAt(i);
            if (StringTools.camelBackWordBreak(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return sb.toString();
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return sb.toString();
            }
            prev = c;
        }
        return sb.toString();
    }

    private static boolean camelBackWordBreak(char prev, char c, char next) {
        if (prev == '\u0000') {
            return false;
        }
        if (Character.isLowerCase(c)) {
            return false;
        }
        if (Character.isLowerCase(prev)) {
            return true;
        }
        if (next == '\u0000') {
            return false;
        }
        return Character.isLowerCase(next);
    }

    public static String convertAllCapsToCamelBack(String allCapsString) {
        return StringTools.convertAllCapsToCamelBack(allCapsString, true);
    }

    public static String convertAllCapsToCamelBack(String allCapsString, boolean capitalizeFirstLetter) {
        int len = allCapsString.length();
        if (len == 0) {
            return EMPTY_STRING;
        }
        char prev = '\u0000';
        char c = '\u0000';
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            prev = c;
            c = allCapsString.charAt(i);
            if (c == '_') continue;
            if (sb.length() == 0) {
                if (capitalizeFirstLetter) {
                    sb.append(Character.toUpperCase(c));
                    continue;
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (prev == '_') {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    private StringTools() {
        throw new UnsupportedOperationException();
    }

    public static double calculateHighestMatchWeight(String string1, String string2) {
        return StringTools.calculateHighestMatchWeight(string1, string2, new char[0], 2);
    }

    public static double calculateHighestMatchWeight(String string1, String string2, char ignoreCharacter) {
        return StringTools.calculateHighestMatchWeight(string1, string2, new char[]{ignoreCharacter}, 2);
    }

    public static double calculateHighestMatchWeight(String string1, String string2, char ignoreCharacter, int minimumMatchingLetterCount) {
        return StringTools.calculateHighestMatchWeight(string1, string2, new char[]{ignoreCharacter}, minimumMatchingLetterCount);
    }

    public static double calculateHighestMatchWeight(String string1, String string2, char[] ignoreCharacters) {
        return StringTools.calculateHighestMatchWeight(string1, string2, ignoreCharacters, 2);
    }

    public static double calculateHighestMatchWeight(String string1, String string2, char[] ignoreCharacters, int minimumMatchingLetterCount) {
        if (string1 == null || string2 == null) {
            return 0.0;
        }
        if (string1.equals(string2)) {
            return 1.0;
        }
        if (StringTools.equals(string1, string2, ignoreCharacters)) {
            double top = string2.length();
            double bottom = string1.length();
            return top / bottom;
        }
        if (string1.indexOf(string2) > -1) {
            double top = string2.length();
            double bottom = string1.length();
            return top / bottom;
        }
        int weight = StringTools.weightContainsPartContinuous(string1, string2, ignoreCharacters, minimumMatchingLetterCount);
        if (weight >= minimumMatchingLetterCount) {
            double weight1 = (double)weight / (double)string1.length();
            double weight2 = (double)weight / (double)string2.length();
            return (weight1 + weight2) / 2.0;
        }
        weight = StringTools.weightContainsPart(string1, string2, ignoreCharacters, minimumMatchingLetterCount);
        if (weight >= minimumMatchingLetterCount) {
            double weight1 = (double)weight / (double)string1.length();
            double weight2 = (double)weight / (double)string2.length();
            return (weight1 + weight2) / 2.0;
        }
        return 0.0;
    }

    public static double calculateHighestMatchWeight(String string1, String string2, int minimumMatchingLetterCount) {
        return StringTools.calculateHighestMatchWeight(string1, string2, new char[0], minimumMatchingLetterCount);
    }

    public static int calculateMatchWeight(String string1, String string2) {
        return StringTools.calculateMatchWeight(string1, string2, new char[0], 2);
    }

    public static int calculateMatchWeight(String string1, String string2, char ignoreCharacter) {
        return StringTools.calculateMatchWeight(string1, string2, new char[]{ignoreCharacter}, 2);
    }

    public static int calculateMatchWeight(String string1, String string2, char ignoreCharacter, int minimumMatchingLetterCount) {
        return StringTools.calculateMatchWeight(string1, string2, new char[]{ignoreCharacter}, minimumMatchingLetterCount);
    }

    public static int calculateMatchWeight(String string1, String string2, char[] ignoreCharacters) {
        return StringTools.calculateMatchWeight(string1, string2, ignoreCharacters, 2);
    }

    public static int calculateMatchWeight(String string1, String string2, char[] ignoreCharacters, int minimumMatchingLetterCount) {
        if (string1 == null || string2 == null) {
            return 0;
        }
        if (string1.equals(string2)) {
            return 10;
        }
        if (StringTools.equals(string1, string2, ignoreCharacters)) {
            return 8;
        }
        if (string1.indexOf(string2) > -1) {
            return 6;
        }
        if (StringTools.containsPartContinuous(string1, string2, ignoreCharacters, minimumMatchingLetterCount)) {
            return 4;
        }
        if (StringTools.containsPart(string1, string2, ignoreCharacters, minimumMatchingLetterCount)) {
            return 2;
        }
        return 0;
    }

    public static int calculateMatchWeight(String string1, String string2, int minimumMatchingLetterCount) {
        return StringTools.calculateMatchWeight(string1, string2, new char[0], minimumMatchingLetterCount);
    }

    public static int calculateMatchWeightIgnoreCase(String string1, String string2) {
        return StringTools.calculateMatchWeightIgnoreCase(string1, string2, new char[0], 2);
    }

    public static int calculateMatchWeightIgnoreCase(String string1, String string2, char ignoreCharacter) {
        return StringTools.calculateMatchWeightIgnoreCase(string1, string2, new char[]{ignoreCharacter}, 2);
    }

    public static int calculateMatchWeightIgnoreCase(String string1, String string2, char[] ignoreCharacters) {
        return StringTools.calculateMatchWeightIgnoreCase(string1, string2, ignoreCharacters, 2);
    }

    public static int calculateMatchWeightIgnoreCase(String string1, String string2, char[] ignoreCharacters, int minimumMatchingLetterCount) {
        if (string1 == null || string2 == null) {
            return 0;
        }
        return StringTools.calculateMatchWeight(string1.toLowerCase(), string2.toLowerCase(), ignoreCharacters, minimumMatchingLetterCount);
    }

    public static int calculateMatchWeightIgnoreCase(String string1, String string2, int minimumMatchingLetterCount) {
        return StringTools.calculateMatchWeightIgnoreCase(string1, string2, new char[0], minimumMatchingLetterCount);
    }

    public static boolean equals(String string1, String string2) {
        return string1 != null && string1.equals(string2) || string2 != null && string2.equals(string1);
    }

    public static boolean equals(String string1, String string2, char ignoreCharacter) {
        return StringTools.equals(string1, string2, new char[]{ignoreCharacter});
    }

    public static boolean equals(String string1, String string2, char[] ignoreCharacters) {
        if (string1 == null || string2 == null) {
            return false;
        }
        for (int index = 0; index < ignoreCharacters.length; ++index) {
            String character = String.valueOf(ignoreCharacters[index]);
            string1 = string1.replaceAll(character, EMPTY_STRING);
            string2 = string2.replaceAll(character, EMPTY_STRING);
        }
        return string1.equals(string2);
    }

    public static boolean equalsIgnoreCase(String string1, String string2) {
        return string1 != null && string1.equalsIgnoreCase(string2) || string2 != null && string2.equalsIgnoreCase(string1);
    }

    public static boolean equalsIgnoreCase(String string1, String string2, char ignoreCharacter) {
        if (string1 == null || string2 == null) {
            return false;
        }
        return StringTools.equals(string1.toLowerCase(), string2.toLowerCase(), new char[]{ignoreCharacter});
    }

    public static boolean equalsIgnoreCase(String string1, String string2, char[] ignoreCharacters) {
        if (string1 == null || string2 == null) {
            return false;
        }
        return StringTools.equals(string1.toLowerCase(), string2.toLowerCase(), ignoreCharacters);
    }

    public static int weightContainsPart(String string1, String string2) {
        return StringTools.weightContainsPart(string1, string2, new char[0], 2);
    }

    public static int weightContainsPart(String string1, String string2, char ignoreCharacter) {
        return StringTools.weightContainsPart(string1, string2, new char[]{ignoreCharacter}, 2);
    }

    public static int weightContainsPart(String string1, String string2, char ignoreCharacter, int minimumMatchingLetterCount) {
        return StringTools.weightContainsPart(string1, string2, new char[]{ignoreCharacter}, minimumMatchingLetterCount);
    }

    public static int weightContainsPart(String string1, String string2, char[] ignoreCharacters) {
        return StringTools.weightContainsPart(string1, string2, ignoreCharacters, 2);
    }

    public static int weightContainsPart(String string1, String string2, char[] ignoreCharacters, int minimumMatchingLetterCount) {
        if (string1 == null || string2 == null || minimumMatchingLetterCount < 2) {
            return 0;
        }
        if (string1.length() < minimumMatchingLetterCount) {
            minimumMatchingLetterCount = string1.length();
        }
        string1 = StringTools.removeIgnoreCharacters(string1, ignoreCharacters);
        string2 = StringTools.removeIgnoreCharacters(string2, ignoreCharacters);
        Position[] positions = string1.length() < string2.length() ? StringTools.weightContainsPartImp(string2, string1) : StringTools.weightContainsPartImp(string1, string2);
        int count = 0;
        int index = positions.length;
        while (--index >= 0) {
            if (Position.canAddWeight(positions, index)) {
                count += positions[index].length;
                continue;
            }
            if (index <= 0) continue;
            Position[] oldPositions = positions;
            positions = new Position[positions.length - 1];
            System.arraycopy(oldPositions, 0, positions, 0, index);
            System.arraycopy(oldPositions, index, positions, index, oldPositions.length - index - 1);
        }
        if (count < minimumMatchingLetterCount) {
            return 0;
        }
        return count;
    }

    public static int weightContainsPart(String string1, String string2, int minimumMatchingLetterCount) {
        return StringTools.weightContainsPart(string1, string2, new char[0], minimumMatchingLetterCount);
    }

    public static int weightContainsPartContinuous(String string1, String string2) {
        return StringTools.weightContainsPartContinuous(string1, string2, new char[0], 2);
    }

    public static int weightContainsPartContinuous(String string1, String string2, char ignoreCharacter) {
        return StringTools.weightContainsPartContinuous(string1, string2, new char[]{ignoreCharacter}, 2);
    }

    public static int weightContainsPartContinuous(String string1, String string2, char ignoreCharacter, int minimumMatchingLetterCount) {
        return StringTools.weightContainsPartContinuous(string1, string2, new char[]{ignoreCharacter}, minimumMatchingLetterCount);
    }

    public static int weightContainsPartContinuous(String string1, String string2, char[] ignoreCharacters) {
        return StringTools.weightContainsPartContinuous(string1, string2, ignoreCharacters, 2);
    }

    public static int weightContainsPartContinuous(String string1, String string2, char[] ignoreCharacters, int minimumMatchingLetterCount) {
        if (string1 == null || string2 == null || minimumMatchingLetterCount < 2) {
            return 0;
        }
        string1 = StringTools.removeIgnoreCharacters(string1, ignoreCharacters);
        string2 = StringTools.removeIgnoreCharacters(string2, ignoreCharacters);
        return StringTools.weightContainsPartContinuousImp(string1, string2, minimumMatchingLetterCount);
    }

    public static int weightContainsPartContinuous(String string1, String string2, int minimumMatchingLetterCount) {
        return StringTools.weightContainsPartContinuous(string1, string2, new char[0], minimumMatchingLetterCount);
    }

    private static int weightContainsPartContinuousImp(String string1, String string2, int minimumMatchingLetterCount) {
        int currentLength = string2.length();
        if (currentLength < minimumMatchingLetterCount) {
            return 0;
        }
        if (string1.indexOf(string2) > -1) {
            return currentLength;
        }
        int weightLeft = StringTools.weightContainsPartContinuousImp(string1, string2.substring(1, currentLength), minimumMatchingLetterCount);
        int weightRight = StringTools.weightContainsPartContinuousImp(string1, string2.substring(0, currentLength - 1), minimumMatchingLetterCount);
        return Math.max(weightLeft, weightRight);
    }

    private static Position[] weightContainsPartImp(String string1, String string2) {
        int currentLength = string2.length();
        if (currentLength == 0) {
            return new Position[0];
        }
        int index = string1.indexOf(string2);
        if (index > -1) {
            Position position = new Position(index, currentLength);
            int string1Length = string1.length();
            while (index > -1 && string1Length - index - 2 * currentLength >= 0) {
                if ((index = string1.indexOf(string2, index + currentLength)) <= -1) continue;
                position.add(index);
            }
            return new Position[]{position};
        }
        if (currentLength > 1) {
            String leftSubString = string2.substring(1, currentLength);
            Position[] leftPos = StringTools.weightContainsPartImp(string1, leftSubString);
            String rightSubString = string2.substring(0, currentLength - 1);
            Position[] rightPos = StringTools.weightContainsPartImp(string1, rightSubString);
            return Position.merge(leftPos, rightPos);
        }
        return new Position[0];
    }

    public static boolean contains(String string1, String string2, char ignoreCharacter) {
        return StringTools.contains(string1, string2, new char[]{ignoreCharacter});
    }

    public static boolean contains(String string1, String string2, char[] ignoreCharacters) {
        if (string1 == null || string2 == null) {
            return false;
        }
        return (string1 = StringTools.removeIgnoreCharacters(string1, ignoreCharacters)).indexOf(string2 = StringTools.removeIgnoreCharacters(string2, ignoreCharacters)) > -1;
    }

    public static boolean containsIgnoreCase(Collection collection, String string) {
        return StringTools.containsIgnoreCase(collection.iterator(), string);
    }

    public static boolean containsIgnoreCase(Iterator iter, String string) {
        if (string == null) {
            return false;
        }
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item == null || !string.equalsIgnoreCase(item.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsPart(String string1, String string2) {
        return StringTools.containsPart(string1, string2, new char[0], 2);
    }

    public static boolean containsPart(String string1, String string2, char ignoreCharacter) {
        return StringTools.containsPart(string1, string2, new char[]{ignoreCharacter}, 2);
    }

    public static boolean containsPart(String string1, String string2, char ignoreCharacter, int minimumMatchingLetterCount) {
        return StringTools.containsPart(string1, string2, new char[]{ignoreCharacter}, minimumMatchingLetterCount);
    }

    public static boolean containsPart(String string1, String string2, char[] ignoreCharacters) {
        return StringTools.containsPart(string1, string2, ignoreCharacters, 2);
    }

    public static boolean containsPart(String string1, String string2, char[] ignoreCharacters, int minimumMatchingLetterCount) {
        return StringTools.weightContainsPart(string1, string2, ignoreCharacters, minimumMatchingLetterCount) >= minimumMatchingLetterCount;
    }

    public static boolean containsPart(String string1, String string2, int minimumMatchingLetterCount) {
        return StringTools.containsPart(string1, string2, new char[0], minimumMatchingLetterCount);
    }

    public static boolean containsPartContinuous(String string1, String string2) {
        return StringTools.containsPartContinuous(string1, string2, new char[0], 2);
    }

    public static boolean containsPartContinuous(String string1, String string2, char ignoreCharacter) {
        return StringTools.containsPartContinuous(string1, string2, new char[]{ignoreCharacter}, 2);
    }

    public static boolean containsPartContinuous(String string1, String string2, char ignoreCharacter, int minimumMatchingLetterCount) {
        return StringTools.containsPartContinuous(string1, string2, new char[0], minimumMatchingLetterCount);
    }

    public static boolean containsPartContinuous(String string1, String string2, char[] ignoreCharacters) {
        return StringTools.containsPartContinuous(string1, string2, ignoreCharacters, 2);
    }

    public static boolean containsPartContinuous(String string1, String string2, char[] ignoreCharacters, int minimumMatchingLetterCount) {
        return StringTools.weightContainsPartContinuous(string1, string2, ignoreCharacters, minimumMatchingLetterCount) >= minimumMatchingLetterCount;
    }

    public static boolean containsPartContinuous(String string1, String string2, int minimumMatchingLetterCount) {
        return StringTools.containsPartContinuous(string1, string2, new char[0], minimumMatchingLetterCount);
    }

    public static String removeIgnoreCharacters(String string, char[] ignoreCharacters) {
        if (string == null || string.length() == 0 || ignoreCharacters.length == 0) {
            return string;
        }
        for (int index = 0; index < ignoreCharacters.length; ++index) {
            String character = String.valueOf(ignoreCharacters[index]);
            string = string.replaceAll(character, EMPTY_STRING);
        }
        return string;
    }

    private static class Position {
        int[] indices = new int[1];
        int length;

        Position() {
            this.indices[0] = -1;
        }

        Position(int index, int length) {
            this();
            this.indices[0] = index;
            this.length = length;
        }

        private static List asList(Position[] array) {
            ArrayList<Position> list = new ArrayList<Position>(array.length);
            for (int index = 0; index < array.length; ++index) {
                list.add(array[index]);
            }
            return list;
        }

        private static boolean canAddWeight(Position[] positions, int index) {
            if (index + 1 == positions.length) {
                return true;
            }
            Position position1 = positions[index];
            Position position2 = positions[index + 1];
            for (int index1 = 0; index1 < position1.indices.length; ++index1) {
                for (int index2 = 0; index2 < position2.indices.length; ++index2) {
                    int posIndex1 = position1.indices[index1];
                    int posIndex2 = position2.indices[index2];
                    if (posIndex1 <= posIndex2) continue;
                    return true;
                }
            }
            return false;
        }

        static Position[] merge(Position[] positions1, Position[] positions2) {
            List positions1List = Position.asList(positions1);
            List positions2List = Position.asList(positions2);
            Iterator iter1 = positions1List.iterator();
            while (iter1.hasNext()) {
                Position firstPosition = (Position)iter1.next();
                Iterator iter2 = positions2List.iterator();
                while (iter2.hasNext()) {
                    Position secondPosition = (Position)iter2.next();
                    if (firstPosition.inside(secondPosition)) {
                        iter2.remove();
                        continue;
                    }
                    if (!secondPosition.inside(firstPosition)) continue;
                    iter1.remove();
                }
            }
            Position[] positions = new Position[positions1List.size() + positions2List.size()];
            System.arraycopy(positions1List.toArray(), 0, positions, 0, positions1List.size());
            System.arraycopy(positions2List.toArray(), 0, positions, positions1List.size(), positions2List.size());
            return positions;
        }

        void add(int index) {
            this.ensureCapacity();
            this.indices[this.indices.length - 1] = index;
        }

        private void ensureCapacity() {
            int[] oldIndices = this.indices;
            this.indices = new int[oldIndices.length + 1];
            System.arraycopy(oldIndices, 0, this.indices, 0, oldIndices.length);
        }

        boolean inside(Position position) {
            for (int index1 = 0; index1 < this.indices.length; ++index1) {
                for (int index2 = 0; index2 < position.indices.length; ++index2) {
                    if (this.indices[index1] + this.length < position.indices[index2] + position.length || this.indices[index1] + this.length < position.length || this.indices[index1] > position.indices[index2]) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

