/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.diff.CompositeDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class ContainerDiff
extends CompositeDiff {
    private final Class javaClass;
    private final Object[] removedElements;
    private final Object[] addedElements;

    public ContainerDiff(Class javaClass, Object object1, Object object2, Diff[] diffs, Object[] removedElements, Object[] addedElements, Differentiator differentiator) {
        super(object1, object2, diffs, differentiator);
        this.javaClass = javaClass;
        this.removedElements = removedElements;
        this.addedElements = addedElements;
    }

    @Override
    public boolean different() {
        if (this.removedElements.length != 0) {
            return true;
        }
        if (this.addedElements.length != 0) {
            return true;
        }
        return super.different();
    }

    @Override
    public void appendDescription(IndentingPrintWriter pw) {
        if (this.different()) {
            pw.print("The ");
            pw.print(ClassTools.shortNameFor(this.javaClass));
            pw.print("s are different:");
            pw.println();
            this.appendDiffs(pw);
            this.appendRemovedElements(pw);
            this.appendAddedElements(pw);
        }
    }

    private void appendDiffs(IndentingPrintWriter pw) {
        Diff[] diffs = this.getDiffs();
        boolean headerPrinted = false;
        for (Diff diff : diffs) {
            if (!diff.different()) continue;
            if (!headerPrinted) {
                pw.println("The following pairs of elements have matching \"keys\" but are different:");
                pw.indent();
                headerPrinted = true;
            }
            diff.appendDescription(pw);
        }
        if (headerPrinted) {
            pw.undent();
        }
    }

    private void appendRemovedElements(IndentingPrintWriter pw) {
        int len = this.removedElements.length;
        if (len == 0) {
            return;
        }
        pw.println("The following elements were removed (they existed in container 1, but not in container 2):");
        pw.indent();
        for (int i = 0; i < len; ++i) {
            pw.println(this.removedElements[i]);
        }
        pw.undent();
    }

    private void appendAddedElements(IndentingPrintWriter pw) {
        int len = this.addedElements.length;
        if (len == 0) {
            return;
        }
        pw.println("The following elements were added (they existed in container 2, but not in container 1):");
        pw.indent();
        for (int i = 0; i < len; ++i) {
            pw.println(this.addedElements[i]);
        }
        pw.undent();
    }

    public Object[] getAddedElements() {
        return this.addedElements;
    }

    public Object[] getRemovedElements() {
        return this.removedElements;
    }
}

