/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class CompositeDiff
implements Diff {
    private final Object object1;
    private final Object object2;
    private final Diff[] diffs;
    private final Differentiator differentiator;

    public CompositeDiff(Object object1, Object object2, Diff[] diffs, Differentiator differentiator) {
        this.object1 = object1;
        this.object2 = object2;
        this.diffs = diffs;
        this.differentiator = differentiator;
    }

    @Override
    public Object getObject1() {
        return this.object1;
    }

    @Override
    public Object getObject2() {
        return this.object2;
    }

    @Override
    public boolean identical() {
        return !this.different();
    }

    @Override
    public boolean different() {
        int i = this.diffs.length;
        while (i-- > 0) {
            if (!this.diffs[i].different()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Differentiator getDifferentiator() {
        return this.differentiator;
    }

    @Override
    public String getDescription() {
        if (this.identical()) {
            return "";
        }
        StringWriter sw = new StringWriter();
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)sw, "    ");
        this.appendHeader(pw);
        pw.indent();
        this.appendDescription(pw);
        pw.undent();
        return ((Object)sw).toString();
    }

    protected void appendHeader(IndentingPrintWriter pw) {
        pw.print("Objects are different:");
        pw.println();
        pw.print("object 1: ");
        pw.print(this.object1);
        pw.println();
        pw.print("object 2: ");
        pw.print(this.object2);
        pw.println();
    }

    @Override
    public void appendDescription(IndentingPrintWriter pw) {
        int len = this.diffs.length;
        for (int i = 0; i < len; ++i) {
            this.diffs[i].appendDescription(pw);
        }
    }

    public Diff[] getDiffs() {
        return this.diffs;
    }

    public Diff getDiff(int index) {
        return this.diffs[index];
    }

    public String toString() {
        return this.identical() ? "<no difference>" : this.getDescription();
    }
}

