/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class ClassConstant
extends Constant {
    private short nameIndex;
    private FieldType fieldDescriptor;

    ClassConstant(ConstantPool pool, byte tag, ClassFileDataInputStream stream) throws IOException {
        super(pool, tag, stream);
    }

    @Override
    void initialize(ClassFileDataInputStream stream) throws IOException {
        this.nameIndex = stream.readU2();
    }

    @Override
    public void displayStringOn(IndentingPrintWriter writer) {
        super.displayStringOn(writer);
        writer.print(" name: ");
        writer.println(this.name());
    }

    @Override
    public String description() {
        return "class";
    }

    public String name() {
        return this.getFieldDescriptor().declaration();
    }

    private String internalName() {
        return this.utf8String(this.nameIndex);
    }

    public String javaTypeName() {
        return this.getFieldDescriptor().javaName();
    }

    public Class javaType() throws ClassNotFoundException {
        return this.getFieldDescriptor().javaClass();
    }

    public int arrayDepth() {
        return this.getFieldDescriptor().arrayDepth();
    }

    public String elementTypeName() {
        return this.getFieldDescriptor().elementTypeName();
    }

    public short getNameIndex() {
        return this.nameIndex;
    }

    @Override
    public Object value() {
        return this.name();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.getFieldDescriptor().accept(visitor);
    }

    public FieldType getFieldDescriptor() {
        if (this.fieldDescriptor == null) {
            this.fieldDescriptor = FieldType.createFieldTypeForClassConstant(this.internalName());
        }
        return this.fieldDescriptor;
    }
}

