/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObject;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractParticle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractSchemaModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroup;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWParticle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.Wildcard;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.XercesTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class ExplicitModelGroup
extends AbstractParticle
implements MWModelGroup {
    private volatile String compositor;
    private List particles;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(ExplicitModelGroup.class);
        descriptor.getInheritancePolicy().setParentClass(AbstractParticle.class);
        descriptor.addDirectMapping("compositor", "@compositor");
        XMLCompositeCollectionMapping particlesMapping = new XMLCompositeCollectionMapping();
        particlesMapping.setAttributeName("particles");
        particlesMapping.setReferenceClass(AbstractSchemaComponent.class);
        particlesMapping.setXPath("particles/particle");
        descriptor.addMapping((DatabaseMapping)particlesMapping);
        return descriptor;
    }

    private ExplicitModelGroup() {
    }

    ExplicitModelGroup(AbstractSchemaModel parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.particles = new Vector();
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.compositor = "sequence";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        List list = this.particles;
        synchronized (list) {
            children.addAll(this.particles);
        }
    }

    ListIterator particles() {
        return this.particles.listIterator();
    }

    @Override
    public String getCompositor() {
        return this.compositor;
    }

    @Override
    public boolean containsWildcard() {
        boolean containsWildcard = false;
        ListIterator stream = this.particles();
        while (stream.hasNext() && !containsWildcard) {
            MWParticle particle = (MWParticle)stream.next();
            if (particle instanceof Wildcard) {
                containsWildcard = true;
                continue;
            }
            if (!(particle instanceof MWModelGroup)) continue;
            containsWildcard |= ((MWModelGroup)particle).containsWildcard();
        }
        return containsWildcard;
    }

    @Override
    public void addDirectlyOwnedComponentsTo(Collection directlyOwnedComponents) {
        ListIterator stream = this.particles();
        while (stream.hasNext()) {
            MWParticle particle = (MWParticle)stream.next();
            if (particle instanceof MWElementDeclaration) {
                directlyOwnedComponents.add(particle);
                continue;
            }
            particle.addDirectlyOwnedComponentsTo(directlyOwnedComponents);
        }
    }

    @Override
    public int compareSchemaOrder(MWElementDeclaration element1, MWElementDeclaration element2) {
        MWParticle particle1 = null;
        MWParticle particle2 = null;
        ListIterator stream = this.particles();
        while (stream.hasNext()) {
            MWParticle particle = (MWParticle)stream.next();
            if (element1.isDescendantOf(particle)) {
                particle1 = particle;
            }
            if (!element2.isDescendantOf(particle)) continue;
            particle2 = particle;
        }
        if (particle1 == null || particle2 == null) {
            return 0;
        }
        if (particle1 == particle2) {
            return particle1.compareSchemaOrder(element1, element2);
        }
        if (this.particles.indexOf(particle1) < this.particles.indexOf(particle2)) {
            return -1;
        }
        if (this.particles.indexOf(particle1) > this.particles.indexOf(particle2)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isEquivalentTo(XSParticleDecl xsParticle) {
        return xsParticle.getTerm() instanceof XSModelGroup;
    }

    @Override
    public Iterator structuralComponents() {
        return this.particles();
    }

    @Override
    public Iterator descriptorContextComponents() {
        return new CompositeIterator(this.descriptorContextComponentIterators());
    }

    private Iterator descriptorContextComponentIterators() {
        return new TransformationIterator(this.particles()){

            @Override
            protected Object transform(Object next) {
                MWParticle particle = (MWParticle)next;
                if (particle.isDescriptorContextComponent()) {
                    return new SingleElementIterator(particle);
                }
                return particle.descriptorContextComponents();
            }
        };
    }

    @Override
    public Iterator xpathComponents() {
        return new CompositeIterator(this.xpathComponentIterators());
    }

    private ListIterator xpathComponentIterators() {
        return new TransformationListIterator(this.particles()){

            @Override
            protected Object transform(Object next) {
                MWParticle particle = (MWParticle)next;
                if (particle instanceof MWElementDeclaration) {
                    return new SingleElementIterator(particle);
                }
                return ((MWParticle)next).xpathComponents();
            }
        };
    }

    @Override
    public MWAttributeDeclaration nestedAttribute(String namespaceUrl, String attributeName) {
        ListIterator stream = this.particles();
        while (stream.hasNext()) {
            MWAttributeDeclaration attribute = ((MWParticle)stream.next()).nestedAttribute(namespaceUrl, attributeName);
            if (attribute == null) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public MWElementDeclaration nestedElement(String namespaceUrl, String elementName) {
        ListIterator stream = this.particles();
        while (stream.hasNext()) {
            MWElementDeclaration element;
            MWParticle particle = (MWParticle)stream.next();
            if (!(particle instanceof MWElementDeclaration ? elementName.equals((element = (MWElementDeclaration)particle).getName()) : (element = particle.nestedElement(namespaceUrl, elementName)) != null)) continue;
            return element;
        }
        return null;
    }

    @Override
    public int totalElementCount() {
        int totalElementCount = 0;
        ListIterator stream = this.particles();
        while (stream.hasNext()) {
            MWParticle particle = (MWParticle)stream.next();
            if (particle instanceof MWElementDeclaration) {
                ++totalElementCount;
                continue;
            }
            totalElementCount += particle.totalElementCount();
        }
        return totalElementCount;
    }

    @Override
    protected void reloadInternal(XSObject xsObject) {
        XSModelGroupImpl groupNode = null;
        if (xsObject instanceof XSParticleDecl) {
            super.reloadInternal(xsObject);
            groupNode = (XSModelGroupImpl)((XSParticleDecl)xsObject).getTerm();
        } else {
            groupNode = (XSModelGroupImpl)xsObject;
        }
        this.reloadCompositor((XSModelGroup)groupNode);
        this.reloadParticles((XSModelGroup)groupNode);
    }

    private void reloadCompositor(XSModelGroup xsGroup) {
        this.compositor = xsGroup.getCompositor() == 2 ? "choice" : (xsGroup.getCompositor() == 1 ? "sequence" : "all");
    }

    private void reloadParticles(XSModelGroup xsGroup) {
        Vector<MWParticle> newParticles = new Vector<MWParticle>();
        ListIterator oldParticles = this.particles();
        while (oldParticles.hasNext()) {
            MWParticle oldParticle = (MWParticle)oldParticles.next();
            if (this.containsEquivalentNode(oldParticle, XercesTools.listIteratorFromXSObjectList(xsGroup.getParticles()))) continue;
            oldParticles.remove();
            this.getProject().nodeRemoved(oldParticle);
        }
        ListIterator<XSObject> particleNodes = XercesTools.listIteratorFromXSObjectList(xsGroup.getParticles());
        while (particleNodes.hasNext()) {
            XSParticleDecl particleNode = (XSParticleDecl)particleNodes.next();
            MWParticle oldParticle = this.containsEquivalentParticle(particleNode, this.particles());
            if (oldParticle != null) {
                oldParticle.reload((XSObject)particleNode);
                newParticles.add(oldParticle);
                continue;
            }
            MWParticle newParticle = MWParticle.ParticleFactory.newParticle(this, particleNode);
            newParticles.add(newParticle);
        }
        this.particles = newParticles;
    }

    private MWParticle containsEquivalentParticle(XSParticleDecl particleNode, ListIterator particles) {
        while (particles.hasNext()) {
            MWParticle particle = (MWParticle)particles.next();
            if (!particle.isEquivalentTo(particleNode)) continue;
            return particle;
        }
        return null;
    }

    private boolean containsEquivalentNode(MWParticle particle, Iterator particleNodes) {
        while (particleNodes.hasNext()) {
            XSParticleDecl particleNode = (XSParticleDecl)particleNodes.next();
            if (!particle.isEquivalentTo(particleNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resolveReferences() {
        super.resolveReferences();
        Iterator stream = this.particles.iterator();
        while (stream.hasNext()) {
            ((MWParticle)stream.next()).resolveReferences();
        }
    }
}

