/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;
import org.eclipse.persistence.internal.libraries.asm.tree.ModuleExportNode;
import org.eclipse.persistence.internal.libraries.asm.tree.ModuleProvideNode;
import org.eclipse.persistence.internal.libraries.asm.tree.ModuleRequireNode;

public class ModuleNode
extends ModuleVisitor {
    public List<ModuleRequireNode> requires;
    public List<ModuleExportNode> exports;
    public List<String> uses;
    public List<ModuleProvideNode> provides;

    public ModuleNode() {
        super(393216);
    }

    public ModuleNode(int n, List<ModuleRequireNode> list, List<ModuleExportNode> list2, List<String> list3, List<ModuleProvideNode> list4) {
        super(393216);
        this.requires = list;
        this.exports = list2;
        this.uses = list3;
        this.provides = list4;
        if (this.getClass() != ModuleNode.class) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void visitRequire(String string, int n) {
        if (this.requires == null) {
            this.requires = new ArrayList<ModuleRequireNode>(5);
        }
        this.requires.add(new ModuleRequireNode(string, n));
    }

    @Override
    public void visitExport(String string, String ... stringArray) {
        if (this.exports == null) {
            this.exports = new ArrayList<ModuleExportNode>(5);
        }
        ArrayList<String> arrayList = null;
        if (stringArray != null) {
            arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        this.exports.add(new ModuleExportNode(string, arrayList));
    }

    @Override
    public void visitUse(String string) {
        if (this.uses == null) {
            this.uses = new ArrayList<String>(5);
        }
        this.uses.add(string);
    }

    @Override
    public void visitProvide(String string, String string2) {
        if (this.provides == null) {
            this.provides = new ArrayList<ModuleProvideNode>(5);
        }
        this.provides.add(new ModuleProvideNode(string, string2));
    }

    @Override
    public void visitEnd() {
    }

    public void accept(ClassVisitor classVisitor) {
        int n;
        ModuleVisitor moduleVisitor = classVisitor.visitModule();
        if (moduleVisitor == null) {
            return;
        }
        if (this.requires != null) {
            for (n = 0; n < this.requires.size(); ++n) {
                this.requires.get(n).accept(moduleVisitor);
            }
        }
        if (this.exports != null) {
            for (n = 0; n < this.exports.size(); ++n) {
                this.exports.get(n).accept(moduleVisitor);
            }
        }
        if (this.uses != null) {
            for (n = 0; n < this.uses.size(); ++n) {
                moduleVisitor.visitUse(this.uses.get(n));
            }
        }
        if (this.provides != null) {
            for (n = 0; n < this.provides.size(); ++n) {
                this.provides.get(n).accept(moduleVisitor);
            }
        }
    }
}

