/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm;

import org.eclipse.persistence.internal.libraries.asm.ByteVector;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;

final class ModuleWriter
extends ModuleVisitor {
    private final ClassWriter cw;
    private int size;
    private int requireCount;
    private ByteVector requires;
    private int exportCount;
    private ByteVector exports;
    private int useCount;
    private ByteVector uses;
    private int provideCount;
    private ByteVector provides;

    ModuleWriter(ClassWriter classWriter) {
        super(393216);
        this.cw = classWriter;
        this.size = 8;
    }

    @Override
    public void visitRequire(String string, int n) {
        if (this.requires == null) {
            this.requires = new ByteVector();
        }
        if ((n & 1) != 0) {
            n = n & 0xFFFFFFFE | 0x20;
        }
        this.requires.putShort(this.cw.newUTF8(string)).putShort(n);
        ++this.requireCount;
        this.size += 4;
    }

    @Override
    public void visitExport(String string, String ... stringArray) {
        if (this.exports == null) {
            this.exports = new ByteVector();
        }
        this.exports.putShort(this.cw.newUTF8(string));
        if (stringArray == null) {
            this.exports.putShort(0);
            this.size += 4;
        } else {
            this.exports.putShort(stringArray.length);
            for (String string2 : stringArray) {
                this.exports.putShort(this.cw.newUTF8(string2));
            }
            this.size += 4 + 2 * stringArray.length;
        }
        ++this.exportCount;
    }

    @Override
    public void visitUse(String string) {
        if (this.uses == null) {
            this.uses = new ByteVector();
        }
        this.uses.putShort(this.cw.newClass(string));
        ++this.useCount;
        this.size += 2;
    }

    @Override
    public void visitProvide(String string, String string2) {
        if (this.provides == null) {
            this.provides = new ByteVector();
        }
        this.provides.putShort(this.cw.newClass(string)).putShort(this.cw.newClass(string2));
        ++this.provideCount;
        this.size += 4;
    }

    @Override
    public void visitEnd() {
    }

    int getSize() {
        return this.size;
    }

    void put(ByteVector byteVector) {
        byteVector.putInt(this.size);
        byteVector.putShort(this.requireCount);
        if (this.requires != null) {
            byteVector.putByteArray(this.requires.data, 0, this.requires.length);
        }
        byteVector.putShort(this.exportCount);
        if (this.exports != null) {
            byteVector.putByteArray(this.exports.data, 0, this.exports.length);
        }
        byteVector.putShort(this.useCount);
        if (this.uses != null) {
            byteVector.putByteArray(this.uses.data, 0, this.uses.length);
        }
        byteVector.putShort(this.provideCount);
        if (this.provides != null) {
            byteVector.putByteArray(this.provides.data, 0, this.provides.length);
        }
    }
}

