/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.extension;

import java.util.ArrayList;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;

public class SDOUtil {
    private static final String HEXADECIMAL_DIGITS = "0123456789abcdefABCDEF";
    private static final String INVALID_URI_WARNING = "SDOUtil: The URI [{0}] used for java package name generation is invalid - generating [{1}].";
    private static final String IS = "is";
    private static final String GET = "get";
    private static final String SET = "set";
    private static boolean asWordSeparator = false;

    private static void preProcessJavaReservedNames(String name) {
        SDOUtil.preProcessReservedNames(name, SDOConstants.javaReservedWordsList, "sdo_type_generation_warning_class_name_violates_java_spec");
    }

    private static void preProcessSDOReservedNames(String name) {
        SDOUtil.preProcessReservedNames(name, SDOConstants.sdoInterfaceReservedWordsList, "sdo_type_generation_warning_class_name_violates_sdo_spec");
    }

    private static void preProcessReservedNames(String name, String[] wordArray, String warningLogKey) {
        int i = 0;
        while (i < wordArray.length) {
            if (wordArray[i].equalsIgnoreCase(name)) {
                AbstractSessionLog.getLog().log(6, warningLogKey, new Object[]{"SDOUtil", name, wordArray[i]});
            }
            ++i;
        }
    }

    public static String getDefaultPackageName() {
        return SDOUtil.getPackageNameFromURI("");
    }

    /*
     * Exception decompiling
     */
    public static String getPackageNameFromURI(String uriString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 13[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String decodeUriHexadecimalEscapeSequence(String uri) {
        StringBuffer sb = new StringBuffer(uri.length());
        int index = 0;
        while (index < uri.length()) {
            char c = uri.charAt(index);
            if (c == '%') {
                if (index + 2 < uri.length() && HEXADECIMAL_DIGITS.indexOf(uri.charAt(index + 1)) >= 0 && HEXADECIMAL_DIGITS.indexOf(uri.charAt(index + 2)) >= 0) {
                    String g = uri.substring(index + 1, index + 3);
                    sb.append((char)Integer.parseInt(g, 16));
                    index += 2;
                } else {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++index;
        }
        return sb.toString();
    }

    public static String className(String s, boolean isClass) {
        return SDOUtil.className(s, true, isClass, true);
    }

    public static String className(String s, boolean flag, boolean isClass, boolean logOn) {
        SDOUtil.preProcessJavaReservedNames(s);
        SDOUtil.preProcessSDOReservedNames(s);
        String[] as = SDOUtil.getWordList(s);
        StringBuffer stringbuffer = new StringBuffer();
        StringBuffer stringbuffer1 = new StringBuffer();
        if (as.length == 0) {
            return stringbuffer.toString();
        }
        int i = 0;
        while (i < as.length) {
            char[] ac = as[i].toCharArray();
            if (Character.isLowerCase(ac[0])) {
                ac[0] = Character.toUpperCase(ac[0]);
            }
            int j = 0;
            while (j < ac.length) {
                if (ac[j] >= ' ' && ac[j] < '\u007f') {
                    if (ac[j] != '_' || !asWordSeparator) {
                        stringbuffer.append(ac[j]);
                    }
                } else if (flag) {
                    stringbuffer.append(SDOUtil.escapeUnicode(stringbuffer1, ac[j]));
                } else {
                    stringbuffer.append(ac[j]);
                }
                ++j;
            }
            ++i;
        }
        String normalizedName = stringbuffer.toString();
        if (!s.equals(normalizedName) && logOn) {
            int logLevel = !s.equalsIgnoreCase(normalizedName) ? 5 : 2;
            if (isClass) {
                AbstractSessionLog.getLog().log(logLevel, "sdo_type_generation_modified_class_naming_format_to", new Object[]{"SDOUtil", s, normalizedName});
            } else {
                AbstractSessionLog.getLog().log(logLevel, "sdo_type_generation_modified_function_naming_format_to", new Object[]{"SDOUtil", s, normalizedName});
            }
        }
        return normalizedName;
    }

    public static String methodName(String s) {
        return SDOUtil.methodName(s, true);
    }

    public static String methodName(String s, boolean flag) {
        return SDOUtil.className(s, flag, false, true);
    }

    public static String setMethodName(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append(SET).append(SDOUtil.methodName(s));
        return stringbuffer.toString();
    }

    public static String getMethodName(String s, String returnType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (returnType.equals(ClassConstants.PBOOLEAN.getName()) || returnType.equals(ClassConstants.BOOLEAN.getName())) {
            stringBuffer.append(IS);
        } else {
            stringBuffer.append(GET);
        }
        stringBuffer.append(SDOUtil.className(s, true, false, false));
        return stringBuffer.toString();
    }

    public static String getBooleanGetMethodName(String s, String returnType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GET);
        stringBuffer.append(SDOUtil.className(s, true, false, false));
        return stringBuffer.toString();
    }

    public static String constantName(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        String[] as = SDOUtil.getWordList(s);
        if (as.length > 0) {
            stringbuffer.append(as[0].toUpperCase());
            int i = 1;
            while (i < as.length) {
                stringbuffer.append('_');
                stringbuffer.append(as[i].toUpperCase());
                ++i;
            }
        }
        return stringbuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static String[] getWordList(String s) {
        arraylist = new ArrayList<String>();
        i = s.length();
        j = 0;
        while (true) {
            if (j < i) ** GOTO lbl8
            break;
lbl-1000:
            // 1 sources

            {
                ++j;
lbl8:
                // 2 sources

                ** while (j < i && SDOUtil.isPunct((char)s.charAt((int)j)))
            }
lbl9:
            // 1 sources

            if (j >= i) break;
            k = SDOUtil.nextBreak(s, j);
            s1 = k != -1 ? s.substring(j, k) : s.substring(j);
            arraylist.add(SDOUtil.escape(s1));
            if (k == -1) break;
            j = k;
        }
        return arraylist.toArray(new String[0]);
    }

    private static boolean isPunct(char c) {
        if (c == '-' || c == '.' || c == ':' || c == '\u00b7' || c == '\u0387' || c == '\u06dd' || c == '\u06de') {
            return true;
        }
        return c == '_' && asWordSeparator;
    }

    private static boolean isUncased(char c) {
        return Character.isLetter(c) && !Character.isUpperCase(c) && !Character.isLowerCase(c);
    }

    /*
     * Unable to fully structure code
     */
    private static int nextBreak(String s, int i) {
        j = s.length();
        k = i;
        while (k < j) {
            c = s.charAt(k);
            if ((c != '_' || SDOUtil.asWordSeparator) && k < j - 1 && ((c1 = s.charAt(k + 1)) != '_' || SDOUtil.asWordSeparator)) {
                if (SDOUtil.isPunct(c1)) {
                    return k + 1;
                }
                if (Character.isDigit(c) && !Character.isDigit(c1)) {
                    return k + 1;
                }
                if (!Character.isDigit(c) && Character.isDigit(c1)) {
                    return k + 1;
                }
                if (Character.isLowerCase(c) && !Character.isLowerCase(c1)) {
                    return k + 1;
                }
                if (k < j - 2) {
                    c2 = s.charAt(k + 2);
                    if (c2 != '_' || SDOUtil.asWordSeparator) {
                        if (Character.isUpperCase(c) && Character.isUpperCase(c1) && Character.isLowerCase(c2)) {
                            return k + 1;
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    if (Character.isLetter(c) && !Character.isLetter(c1)) {
                        return k + 1;
                    }
                    if (!Character.isLetter(c) && Character.isLetter(c1)) {
                        return k + 1;
                    }
                    if (SDOUtil.isUncased(c) && !SDOUtil.isUncased(c1)) {
                        return k + 1;
                    }
                    if (!SDOUtil.isUncased(c) && SDOUtil.isUncased(c1)) {
                        return k + 1;
                    }
                }
            }
            ++k;
        }
        return -1;
    }

    private static String escape(String s) {
        int i = s.length();
        int j = 0;
        while (j < i) {
            if (!Character.isJavaIdentifierPart(s.charAt(j))) {
                StringBuffer stringbuffer = new StringBuffer(s.substring(0, j));
                SDOUtil.escape(stringbuffer, s, j);
                return stringbuffer.toString();
            }
            ++j;
        }
        return s;
    }

    private static void escape(StringBuffer stringbuffer, String s, int i) {
        int j = s.length();
        int k = i;
        while (k < j) {
            char c = s.charAt(k);
            if (Character.isJavaIdentifierPart(c)) {
                stringbuffer.append(c);
            } else {
                stringbuffer.append("_");
                if (c <= '\u000f') {
                    stringbuffer.append("000");
                } else if (c <= '\u00ff') {
                    stringbuffer.append("00");
                } else if (c <= '\u0fff') {
                    stringbuffer.append("0");
                }
                stringbuffer.append(Integer.toString(c, 16));
            }
            ++k;
        }
    }

    private static String escapeUnicode(StringBuffer stringbuffer, char c) {
        String s = Integer.toString(c, 16);
        int i = s.length();
        stringbuffer.setLength(6);
        stringbuffer.setCharAt(0, '\\');
        stringbuffer.setCharAt(1, 'u');
        int j = 2;
        int k = i;
        while (k < 4) {
            stringbuffer.setCharAt(j, '0');
            ++k;
            ++j;
        }
        stringbuffer.replace(j, 6, s);
        return stringbuffer.toString();
    }

    public static String getJavaTypeForProperty(SDOProperty property) {
        if (property.isMany() || property.getType().isXsdList()) {
            return "java.util.List";
        }
        SDOType propertyType = property.getType();
        if (propertyType.isDataType()) {
            Class instanceClass = propertyType.getInstanceClass();
            if (ClassConstants.ABYTE.equals(instanceClass)) {
                return "Byte[]";
            }
            if (ClassConstants.APBYTE.equals(instanceClass)) {
                return "byte[]";
            }
        }
        return propertyType.getInstanceClassName();
    }

    public static String getBuiltInType(String typeName) {
        if (typeName.equals(ClassConstants.PBOOLEAN.getName()) || typeName.equals(ClassConstants.BOOLEAN.getName())) {
            return "Boolean";
        }
        if (typeName.equals(ClassConstants.PBYTE.getName()) || typeName.equals(ClassConstants.BYTE.getName())) {
            return "Byte";
        }
        if (typeName.equals("byte[]") || typeName.equals("Byte[]") || typeName.equals(ClassConstants.APBYTE.getName()) || typeName.equals(ClassConstants.ABYTE.getName())) {
            return "Bytes";
        }
        if (typeName.equals(ClassConstants.PCHAR.getName()) || typeName.equals(ClassConstants.CHAR.getName())) {
            return "Char";
        }
        if (typeName.equals(ClassConstants.PDOUBLE.getName()) || typeName.equals(ClassConstants.DOUBLE.getName())) {
            return "Double";
        }
        if (typeName.equals(ClassConstants.PFLOAT.getName()) || typeName.equals(ClassConstants.FLOAT.getName())) {
            return "Float";
        }
        if (typeName.equals(ClassConstants.PLONG.getName()) || typeName.equals(ClassConstants.LONG.getName())) {
            return "Long";
        }
        if (typeName.equals(ClassConstants.PSHORT.getName()) || typeName.equals(ClassConstants.SHORT.getName())) {
            return "Short";
        }
        if (typeName.equals(ClassConstants.PINT.getName()) || typeName.equals(ClassConstants.INTEGER.getName())) {
            return "Int";
        }
        if (typeName.equals(ClassConstants.STRING.getName())) {
            return "String";
        }
        if (typeName.equals(ClassConstants.BIGINTEGER.getName())) {
            return "BigInteger";
        }
        if (typeName.equals(ClassConstants.BIGDECIMAL.getName())) {
            return "BigDecimal";
        }
        if (typeName.equals(ClassConstants.UTILDATE.getName())) {
            return "Date";
        }
        if (typeName.equals("java.util.List")) {
            return "List";
        }
        return null;
    }
}

