/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.util.iterator;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.ArrayListIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableListIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.ListMutator;
import org.eclipse.persistence.jpa.jpql.util.iterator.NullListMutator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneListIterator<E>
implements IterableListIterator<E> {
    private int cursor = 0;
    private ListMutator<E> mutator;
    private ListIterator<E> nestedListIterator;
    private State state;

    public CloneListIterator(List<? extends E> list) {
        this(list, NullListMutator.instance());
    }

    public CloneListIterator(List<? extends E> list, ListMutator<E> mutator) {
        this.mutator = mutator;
        this.state = State.UNKNOWN;
        this.nestedListIterator = new ArrayListIterator(list.toArray());
    }

    @Override
    public void add(E item) {
        this.nestedListIterator.add(item);
        this.add(this.cursor, item);
        ++this.cursor;
    }

    protected void add(int index, E item) {
        this.mutator.add(index, item);
    }

    @Override
    public boolean hasNext() {
        return this.nestedListIterator.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.nestedListIterator.hasPrevious();
    }

    @Override
    public ListIterator<E> iterator() {
        return this;
    }

    @Override
    public E next() {
        E next = this.nestedListIterator.next();
        ++this.cursor;
        this.state = State.NEXT;
        return next;
    }

    @Override
    public int nextIndex() {
        return this.nestedListIterator.nextIndex();
    }

    @Override
    public E previous() {
        E previous = this.nestedListIterator.previous();
        --this.cursor;
        this.state = State.PREVIOUS;
        return previous;
    }

    @Override
    public int previousIndex() {
        return this.nestedListIterator.previousIndex();
    }

    @Override
    public void remove() {
        this.nestedListIterator.remove();
        if (this.state == State.PREVIOUS) {
            this.remove(this.cursor);
        } else {
            --this.cursor;
            this.remove(this.cursor);
        }
    }

    protected void remove(int index) {
        this.mutator.remove(index);
    }

    @Override
    public void set(E item) {
        this.nestedListIterator.set(item);
        if (this.state == State.PREVIOUS) {
            this.set(this.cursor, item);
        } else {
            this.set(this.cursor - 1, item);
        }
    }

    protected void set(int index, E item) {
        this.mutator.set(index, item);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NEXT,
        PREVIOUS,
        UNKNOWN;

    }
}

