/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.util.iterator;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.jpa.jpql.util.iterator.ArrayIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListIterator<E>
extends ArrayIterator<E>
implements IterableListIterator<E> {
    private int minIndex;

    public <T extends E> ArrayListIterator(T ... array) {
        this(array, 0, array.length);
    }

    public <T extends E> ArrayListIterator(T[] array, int start, int length) {
        super(array, start, length);
        this.minIndex = start;
    }

    @Override
    public void add(E item) {
        throw new UnsupportedOperationException("An ArrayListIterator is read-only.");
    }

    @Override
    public boolean hasPrevious() {
        return this.nextIndex > this.minIndex;
    }

    @Override
    public ListIterator<E> iterator() {
        return (ListIterator)super.iterator();
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    @Override
    public E previous() {
        if (this.hasPrevious()) {
            return (E)this.array[--this.nextIndex];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previousIndex() {
        return this.nextIndex - 1;
    }

    @Override
    public void set(E item) {
        throw new UnsupportedOperationException("An ArrayListIterator is read-only.");
    }
}

