/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LikeExpression
extends AbstractExpression {
    private AbstractExpression escapeCharacter;
    private String escapeIdentifier;
    private boolean hasEscape;
    private boolean hasNot;
    private boolean hasSpaceAfterEscape;
    private boolean hasSpaceAfterLike;
    private boolean hasSpaceAfterPatternValue;
    private String likeIdentifier;
    private String notIdentifier;
    private AbstractExpression patternValue;
    private AbstractExpression stringExpression;

    public LikeExpression(AbstractExpression parent, AbstractExpression stringExpression) {
        super(parent, "LIKE");
        if (stringExpression != null) {
            this.stringExpression = stringExpression;
            this.stringExpression.setParent(this);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getStringExpression().accept(visitor);
        this.getPatternValue().accept(visitor);
        this.getEscapeCharacter().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getStringExpression());
        children.add(this.getPatternValue());
        children.add(this.getEscapeCharacter());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.stringExpression != null) {
            children.add(this.stringExpression);
        }
        if (this.hasNot) {
            children.add(this.buildStringExpression(' '));
            children.add(this.buildStringExpression("NOT"));
        }
        children.add(this.buildStringExpression(' '));
        children.add(this.buildStringExpression("LIKE"));
        if (this.hasSpaceAfterLike) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.patternValue != null) {
            children.add(this.patternValue);
        }
        if (this.hasSpaceAfterPatternValue) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasEscape) {
            children.add(this.buildStringExpression("ESCAPE"));
        }
        if (this.hasSpaceAfterEscape) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.escapeCharacter != null) {
            children.add(this.escapeCharacter);
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.patternValue != null && this.patternValue.isAncestor(expression)) {
            return this.getQueryBNF("pattern_value");
        }
        if (this.escapeCharacter != null && this.escapeCharacter.isAncestor(expression)) {
            return this.getQueryBNF("like_escape");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualEscapeIdentifier() {
        return this.escapeIdentifier != null ? this.escapeIdentifier : "";
    }

    public String getActualLikeIdentifier() {
        return this.likeIdentifier;
    }

    public String getActualNotIdentifier() {
        return this.notIdentifier != null ? this.notIdentifier : "";
    }

    public Expression getEscapeCharacter() {
        if (this.escapeCharacter == null) {
            this.escapeCharacter = this.buildNullExpression();
        }
        return this.escapeCharacter;
    }

    public String getIdentifier() {
        return this.hasNot ? "NOT LIKE" : "LIKE";
    }

    public Expression getPatternValue() {
        if (this.patternValue == null) {
            this.patternValue = this.buildNullExpression();
        }
        return this.patternValue;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("like_expression");
    }

    public Expression getStringExpression() {
        if (this.stringExpression == null) {
            this.stringExpression = this.buildNullExpression();
        }
        return this.stringExpression;
    }

    public boolean hasEscape() {
        return this.hasEscape;
    }

    public boolean hasEscapeCharacter() {
        return this.escapeCharacter != null && !this.escapeCharacter.isNull();
    }

    public boolean hasNot() {
        return this.hasNot;
    }

    public boolean hasPatternValue() {
        return this.patternValue != null && !this.patternValue.isNull();
    }

    public boolean hasSpaceAfterEscape() {
        return this.hasSpaceAfterEscape;
    }

    public boolean hasSpaceAfterLike() {
        return this.hasSpaceAfterLike;
    }

    public boolean hasSpaceAfterPatternValue() {
        return this.hasSpaceAfterPatternValue;
    }

    public boolean hasSpaceAfterStringExpression() {
        return this.hasStringExpression();
    }

    public boolean hasStringExpression() {
        return this.stringExpression != null && !this.stringExpression.isNull();
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        char character = word.charAt(0);
        if (this.getQueryBNF("pattern_value").handleAggregate() && (character == '+' || character == '-' || character == '*' || character == '/')) {
            return false;
        }
        return super.isParsingComplete(wordParser, word, expression) || word.equalsIgnoreCase("ESCAPE") || word.equalsIgnoreCase("AND") || word.equalsIgnoreCase("OR") || expression != null;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.hasNot = wordParser.startsWithIgnoreCase('N');
        if (this.hasNot) {
            this.notIdentifier = wordParser.moveForward("NOT");
            wordParser.skipLeadingWhitespace();
        }
        this.likeIdentifier = wordParser.moveForward("LIKE");
        this.hasSpaceAfterLike = wordParser.skipLeadingWhitespace() > 0;
        this.patternValue = this.parse(wordParser, "pattern_value", tolerant);
        int count = wordParser.skipLeadingWhitespace();
        this.hasEscape = wordParser.startsWithIdentifier("ESCAPE");
        if (this.hasEscape) {
            this.hasSpaceAfterPatternValue = count > 0;
            count = 0;
            this.escapeIdentifier = wordParser.moveForward("ESCAPE");
            this.hasSpaceAfterEscape = wordParser.skipLeadingWhitespace() > 0;
        } else if (tolerant) {
            this.hasSpaceAfterPatternValue = count > 0;
        } else {
            wordParser.moveBackward(count);
            return;
        }
        char character = wordParser.character();
        if (character == '\'') {
            this.escapeCharacter = new StringLiteral(this, wordParser.word());
            this.escapeCharacter.parse(wordParser, tolerant);
            count = 0;
        } else if (character == ':' || character == '?') {
            this.escapeCharacter = new InputParameter(this, wordParser.word());
            this.escapeCharacter.parse(wordParser, tolerant);
            count = 0;
        } else {
            this.escapeCharacter = this.parse(wordParser, "like_escape", tolerant);
            if (!this.hasEscape && this.escapeCharacter == null && !wordParser.isTail()) {
                this.hasSpaceAfterPatternValue = false;
                wordParser.moveBackward(count);
            }
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.stringExpression != null) {
            this.stringExpression.toParsedText(writer, actual);
            writer.append(' ');
        }
        if (actual) {
            if (this.hasNot) {
                writer.append(this.notIdentifier);
                writer.append(' ');
            }
            writer.append(this.likeIdentifier);
        } else {
            writer.append(this.hasNot ? "NOT LIKE" : "LIKE");
        }
        if (this.hasSpaceAfterLike) {
            writer.append(' ');
        }
        if (this.patternValue != null) {
            this.patternValue.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterPatternValue) {
            writer.append(' ');
        }
        if (this.hasEscape) {
            writer.append(actual ? this.escapeIdentifier : "ESCAPE");
        }
        if (this.hasSpaceAfterEscape) {
            writer.append(' ');
        }
        if (this.escapeCharacter != null) {
            this.escapeCharacter.toParsedText(writer, actual);
        }
    }
}

